/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.grpc;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.grpc.GrpcExceptionHandlerFunction;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaStatusException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.grpc.StatusExceptionConverter;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Objects;

public final class GrpcExceptionHandlerFunctionUtil {
    public static Metadata generateMetadataFromThrowable(Throwable exception) {
        Metadata metadata = Status.trailersFromThrowable((Throwable)GrpcExceptionHandlerFunctionUtil.peelAndUnwrap(exception));
        return metadata != null ? metadata : new Metadata();
    }

    public static Status fromThrowable(RequestContext ctx, GrpcExceptionHandlerFunction exceptionHandler, Throwable t, Metadata metadata) {
        Status status = Status.fromThrowable((Throwable)GrpcExceptionHandlerFunctionUtil.peelAndUnwrap(t));
        Throwable cause = status.getCause();
        if (cause == null) {
            return status;
        }
        return GrpcExceptionHandlerFunctionUtil.applyExceptionHandler(ctx, exceptionHandler, status, cause, metadata);
    }

    public static Status applyExceptionHandler(RequestContext ctx, GrpcExceptionHandlerFunction exceptionHandler, Status status, Throwable cause, Metadata metadata) {
        Throwable peeled = GrpcExceptionHandlerFunctionUtil.peelAndUnwrap(cause);
        status = exceptionHandler.apply(ctx, status, peeled, metadata);
        assert (status != null);
        return status;
    }

    private static Throwable peelAndUnwrap(Throwable t) {
        Objects.requireNonNull(t, "t");
        for (Throwable cause = t = Exceptions.peel((Throwable)t); cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ArmeriaStatusException)) continue;
            return StatusExceptionConverter.toGrpc((ArmeriaStatusException)cause);
        }
        return t;
    }

    private GrpcExceptionHandlerFunctionUtil() {
    }
}

