/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import io.grpc.Channel;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import javax.annotation.Nullable;

final class GrpcClientFactoryUtil {
    @Nullable
    static <T> Method findStubFactoryMethod(Class<T> clientType) {
        for (Method method : clientType.getEnclosingClass().getDeclaredMethods()) {
            Class<?>[] methodParameterTypes;
            String methodName;
            int methodModifiers = method.getModifiers();
            if (!Modifier.isPublic(methodModifiers) || !Modifier.isStatic(methodModifiers) || !(methodName = method.getName()).toLowerCase().endsWith("stub") || (methodParameterTypes = method.getParameterTypes()).length != 1 || methodParameterTypes[0] != Channel.class || !clientType.isAssignableFrom(method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    static IllegalStateException newClientStubCreationException(Throwable cause) {
        return new IllegalStateException("Could not create a gRPC stub through reflection.", cause);
    }

    private GrpcClientFactoryUtil() {
    }
}

