/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.grpc.GrpcClientStubFactory;
import com.linecorp.armeria.internal.client.grpc.GrpcClientFactoryUtil;
import io.grpc.Channel;
import io.grpc.ServiceDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public final class KotlinGrpcClientStubFactory
implements GrpcClientStubFactory {
    @Override
    @Nullable
    public ServiceDescriptor findServiceDescriptor(Class<?> clientType) {
        if (clientType.getName().endsWith("CoroutineStub")) {
            Annotation annotation = KotlinGrpcClientStubFactory.stubForAnnotation(clientType);
            try {
                Method valueMethod = annotation.annotationType().getDeclaredMethod("value", null);
                Class<?> generatedStub = KotlinGrpcClientStubFactory.generatedStub(annotation, valueMethod);
                Method getServiceDescriptor = generatedStub.getDeclaredMethod("getServiceDescriptor", null);
                try {
                    return (ServiceDescriptor)getServiceDescriptor.invoke(generatedStub, new Object[0]);
                }
                catch (IllegalAccessException | InvocationTargetException e) {
                    throw new IllegalStateException("Could not invoke getServiceDescriptor on a gRPC Kotlin client stub.");
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException("Could not find value getter on StubFor annotation.");
            }
        }
        return null;
    }

    private static Annotation stubForAnnotation(Class<?> clientType) {
        try {
            Class<?> annotationClass = Class.forName("io.grpc.kotlin.StubFor");
            Object annotation = clientType.getAnnotation(annotationClass);
            if (annotation == null) {
                throw new IllegalStateException("Could not find StubFor annotation on a gRPC Kotlin client stub.");
            }
            return annotation;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Could not find StubFor annotation on a gRPC Kotlin client stub.");
        }
    }

    private static Class<?> generatedStub(Annotation annotation, Method valueMethod) {
        try {
            return (Class)valueMethod.invoke((Object)annotation, null);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Could not find a gRPC Kotlin generated client stub.");
        }
    }

    @Override
    public Object newClientStub(Class<?> clientType, Channel channel) {
        Constructor<?> constructor = null;
        for (Constructor<?> ctor : clientType.getConstructors()) {
            Class<?>[] methodParameterTypes = ctor.getParameterTypes();
            if (methodParameterTypes.length != 1 || methodParameterTypes[0] != Channel.class) continue;
            constructor = ctor;
            break;
        }
        if (constructor == null) {
            throw new IllegalStateException("Could not find a constructor on a gRPC Kotlin client stub: " + clientType.getName());
        }
        try {
            return constructor.newInstance(channel);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw GrpcClientFactoryUtil.newClientStubCreationException(e);
        }
    }
}

