/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.GrpcStatusFunction;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.common.grpc.MetadataUtil;
import com.linecorp.armeria.internal.common.grpc.TimeoutHeaderUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.AbstractHttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.grpc.ArmeriaServerCall;
import com.linecorp.armeria.server.grpc.GrpcRequestUtil;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.HandlerRegistry;
import com.linecorp.armeria.server.grpc.ProtoReflectionServiceInterceptor;
import io.grpc.Codec;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Server;
import io.grpc.ServerCall;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FramedGrpcService
extends AbstractHttpService
implements GrpcService {
    private static final Logger logger = LoggerFactory.getLogger(FramedGrpcService.class);
    private final HandlerRegistry registry;
    private final Set<Route> routes;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final Set<SerializationFormat> supportedSerializationFormats;
    private final Map<String, GrpcJsonMarshaller> jsonMarshallers;
    @Nullable
    private final ProtoReflectionServiceInterceptor protoReflectionServiceInterceptor;
    @Nullable
    private final GrpcStatusFunction statusFunction;
    private final int maxOutboundMessageSizeBytes;
    private final boolean useBlockingTaskExecutor;
    private final boolean unsafeWrapRequestBuffers;
    private final boolean useClientTimeoutHeader;
    private final String advertisedEncodingsHeader;
    private final Map<SerializationFormat, ResponseHeaders> defaultHeaders;
    private int maxInboundMessageSizeBytes;

    FramedGrpcService(HandlerRegistry registry, Set<Route> routes, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, Set<SerializationFormat> supportedSerializationFormats, Function<? super ServiceDescriptor, ? extends GrpcJsonMarshaller> jsonMarshallerFactory, @Nullable ProtoReflectionServiceInterceptor protoReflectionServiceInterceptor, @Nullable GrpcStatusFunction statusFunction, int maxOutboundMessageSizeBytes, boolean useBlockingTaskExecutor, boolean unsafeWrapRequestBuffers, boolean useClientTimeoutHeader, int maxInboundMessageSizeBytes) {
        this.registry = Objects.requireNonNull(registry, "registry");
        this.routes = Objects.requireNonNull(routes, "routes");
        this.decompressorRegistry = Objects.requireNonNull(decompressorRegistry, "decompressorRegistry");
        this.compressorRegistry = Objects.requireNonNull(compressorRegistry, "compressorRegistry");
        this.supportedSerializationFormats = supportedSerializationFormats;
        this.useClientTimeoutHeader = useClientTimeoutHeader;
        this.jsonMarshallers = supportedSerializationFormats.stream().noneMatch(GrpcSerializationFormats::isJson) ? ImmutableMap.of() : (Map)registry.services().stream().map(ServerServiceDefinition::getServiceDescriptor).distinct().collect(ImmutableMap.toImmutableMap(ServiceDescriptor::getName, jsonMarshallerFactory));
        this.protoReflectionServiceInterceptor = protoReflectionServiceInterceptor;
        this.statusFunction = statusFunction;
        this.maxOutboundMessageSizeBytes = maxOutboundMessageSizeBytes;
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        this.unsafeWrapRequestBuffers = unsafeWrapRequestBuffers;
        this.maxInboundMessageSizeBytes = maxInboundMessageSizeBytes;
        this.advertisedEncodingsHeader = String.join((CharSequence)",", decompressorRegistry.getAdvertisedMessageEncodings());
        this.defaultHeaders = (Map)supportedSerializationFormats.stream().map(format -> {
            ResponseHeadersBuilder builder = ResponseHeaders.builder((HttpStatus)HttpStatus.OK).contentType(format.mediaType()).add((CharSequence)GrpcHeaderNames.GRPC_ENCODING, Codec.Identity.NONE.getMessageEncoding());
            if (!this.advertisedEncodingsHeader.isEmpty()) {
                builder.add((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING, this.advertisedEncodingsHeader);
            }
            return new AbstractMap.SimpleImmutableEntry<SerializationFormat, ResponseHeaders>((SerializationFormat)format, builder.build());
        }).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    protected HttpResponse doPost(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        String timeoutHeader;
        MediaType contentType = req.contentType();
        SerializationFormat serializationFormat = this.findSerializationFormat(contentType);
        if (serializationFormat == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Missing or invalid Content-Type header.");
        }
        ctx.logBuilder().serializationFormat(serializationFormat);
        String methodName = GrpcRequestUtil.determineMethod(ctx);
        if (methodName == null) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Invalid path.");
        }
        ServerMethodDefinition<?, ?> method = this.registry.lookupMethod(methodName);
        if (method == null) {
            return HttpResponse.of((ResponseHeaders)((ResponseHeaders)ArmeriaServerCall.statusToTrailers(ctx, (HttpHeadersBuilder)this.defaultHeaders.get(serializationFormat).toBuilder(), Status.UNIMPLEMENTED.withDescription("Method not found: " + methodName), new Metadata())));
        }
        if (this.useClientTimeoutHeader && (timeoutHeader = req.headers().get((CharSequence)GrpcHeaderNames.GRPC_TIMEOUT)) != null) {
            try {
                long timeout = TimeoutHeaderUtil.fromHeaderValue(timeoutHeader);
                if (timeout == 0L) {
                    ctx.clearRequestTimeout();
                } else {
                    ctx.setRequestTimeout(TimeoutMode.SET_FROM_NOW, Duration.ofNanos(timeout));
                }
            }
            catch (IllegalArgumentException e) {
                return HttpResponse.of((ResponseHeaders)((ResponseHeaders)ArmeriaServerCall.statusToTrailers(ctx, (HttpHeadersBuilder)this.defaultHeaders.get(serializationFormat).toBuilder(), GrpcStatus.fromThrowable(this.statusFunction, e), new Metadata())));
            }
        }
        ctx.logBuilder().defer(new RequestLogProperty[]{RequestLogProperty.REQUEST_CONTENT, RequestLogProperty.RESPONSE_CONTENT});
        HttpResponseWriter res = HttpResponse.streaming();
        ArmeriaServerCall<?, ?> call = this.startCall(methodName, method, ctx, req, res, serializationFormat);
        if (call != null) {
            ctx.whenRequestCancelling().thenRun(() -> call.close(Status.CANCELLED, new Metadata()));
            call.startDeframing();
        }
        return res;
    }

    @Nullable
    private <I, O> ArmeriaServerCall<I, O> startCall(String fullMethodName, ServerMethodDefinition<I, O> methodDef, ServiceRequestContext ctx, HttpRequest req, HttpResponseWriter res, SerializationFormat serializationFormat) {
        ServerCall.Listener listener;
        MethodDescriptor methodDescriptor = methodDef.getMethodDescriptor();
        ArmeriaServerCall call = new ArmeriaServerCall(req, methodDescriptor, this.compressorRegistry, this.decompressorRegistry, res, this.maxInboundMessageSizeBytes, this.maxOutboundMessageSizeBytes, ctx, serializationFormat, this.jsonMarshallers.get(methodDescriptor.getServiceName()), this.unsafeWrapRequestBuffers, this.useBlockingTaskExecutor, this.defaultHeaders.get(serializationFormat), this.statusFunction);
        try (SafeCloseable ignored = ctx.push();){
            listener = methodDef.getServerCallHandler().startCall(call, MetadataUtil.copyFromHeaders((HttpHeaders)req.headers()));
        }
        catch (Throwable t) {
            call.setListener(new EmptyListener());
            call.close(GrpcStatus.fromThrowable(this.statusFunction, t), new Metadata());
            logger.warn("Exception thrown from streaming request stub method before processing any request data - this is likely a bug in the stub implementation.");
            return null;
        }
        if (listener == null) {
            throw new NullPointerException("startCall() returned a null listener for method " + fullMethodName);
        }
        call.setListener(listener);
        return call;
    }

    public void serviceAdded(ServiceConfig cfg) {
        if (this.maxInboundMessageSizeBytes == -1) {
            this.maxInboundMessageSizeBytes = (int)Math.min(cfg.maxRequestLength(), Integer.MAX_VALUE);
        }
        if (this.protoReflectionServiceInterceptor != null) {
            Map grpcServices = (Map)cfg.server().config().virtualHosts().stream().flatMap(host -> host.serviceConfigs().stream()).map(serviceConfig -> (FramedGrpcService)serviceConfig.service().as(FramedGrpcService.class)).filter(Objects::nonNull).flatMap(service -> service.services().stream()).collect(ImmutableMap.toImmutableMap(def -> def.getServiceDescriptor().getName(), Function.identity(), (a, b) -> a));
            this.protoReflectionServiceInterceptor.setServer(FramedGrpcService.newDummyServer(grpcServices));
        }
    }

    private static Server newDummyServer(final Map<String, ServerServiceDefinition> grpcServices) {
        return new Server(){

            public Server start() {
                throw new UnsupportedOperationException();
            }

            public List<ServerServiceDefinition> getServices() {
                return ImmutableList.copyOf(grpcServices.values());
            }

            public List<ServerServiceDefinition> getImmutableServices() {
                return this.getServices();
            }

            public List<ServerServiceDefinition> getMutableServices() {
                return ImmutableList.of();
            }

            public Server shutdown() {
                throw new UnsupportedOperationException();
            }

            public Server shutdownNow() {
                throw new UnsupportedOperationException();
            }

            public boolean isShutdown() {
                throw new UnsupportedOperationException();
            }

            public boolean isTerminated() {
                throw new UnsupportedOperationException();
            }

            public boolean awaitTermination(long timeout, TimeUnit unit) {
                throw new UnsupportedOperationException();
            }

            public void awaitTermination() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public boolean isFramed() {
        return true;
    }

    @Override
    public List<ServerServiceDefinition> services() {
        List<ServerServiceDefinition> services = this.registry.services();
        assert (services instanceof ImmutableList);
        return services;
    }

    @Override
    public Map<String, ServerMethodDefinition<?, ?>> methods() {
        Map<String, ServerMethodDefinition<?, ?>> methods = this.registry.methods();
        assert (methods instanceof ImmutableMap);
        return methods;
    }

    @Override
    public Set<SerializationFormat> supportedSerializationFormats() {
        return this.supportedSerializationFormats;
    }

    @Nullable
    private SerializationFormat findSerializationFormat(@Nullable MediaType contentType) {
        if (contentType == null) {
            return null;
        }
        for (SerializationFormat format : this.supportedSerializationFormats) {
            if (!format.isAccepted(contentType)) continue;
            return format;
        }
        return null;
    }

    public Set<Route> routes() {
        return this.routes;
    }

    private static class EmptyListener<T>
    extends ServerCall.Listener<T> {
        private EmptyListener() {
        }
    }
}

