/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageDeframer;
import com.linecorp.armeria.common.grpc.protocol.ArmeriaMessageFramer;
import com.linecorp.armeria.common.grpc.protocol.DeframedMessage;
import com.linecorp.armeria.common.grpc.protocol.GrpcHeaderNames;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.stream.HttpDecoder;
import com.linecorp.armeria.internal.common.grpc.GrpcStatus;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.grpc.GrpcRequestUtil;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.HandlerRegistry;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.Status;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

final class UnframedGrpcService
extends SimpleDecoratingHttpService
implements GrpcService {
    private static final char LINE_SEPARATOR = '\n';
    private final Map<String, ServerMethodDefinition<?, ?>> methodsByName;
    private final GrpcService delegateGrpcService;

    UnframedGrpcService(GrpcService delegate, HandlerRegistry registry) {
        super((HttpService)delegate);
        Preconditions.checkArgument((boolean)delegate.isFramed(), (Object)"Decorated service must be a framed GrpcService.");
        this.delegateGrpcService = delegate;
        this.methodsByName = registry.methods();
    }

    @Override
    public boolean isFramed() {
        return false;
    }

    @Override
    public List<ServerServiceDefinition> services() {
        return this.delegateGrpcService.services();
    }

    @Override
    public Map<String, ServerMethodDefinition<?, ?>> methods() {
        return this.methodsByName;
    }

    @Override
    public Set<SerializationFormat> supportedSerializationFormats() {
        return this.delegateGrpcService.supportedSerializationFormats();
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        MediaType framedContentType;
        ServerMethodDefinition<?, ?> methodDef;
        RequestHeaders clientHeaders = req.headers();
        MediaType contentType = clientHeaders.contentType();
        if (contentType == null) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        for (SerializationFormat format : GrpcSerializationFormats.values()) {
            if (!format.isAccepted(contentType)) continue;
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        String methodName = GrpcRequestUtil.determineMethod(ctx);
        MethodDescriptor method = methodName != null ? ((methodDef = this.methodsByName.get(methodName)) != null ? methodDef.getMethodDescriptor() : null) : null;
        if (method == null) {
            return (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)req);
        }
        if (method.getType() != MethodDescriptor.MethodType.UNARY) {
            return HttpResponse.of((HttpStatus)HttpStatus.BAD_REQUEST, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Only unary methods can be used with non-framed requests.");
        }
        RequestHeadersBuilder grpcHeaders = clientHeaders.toBuilder();
        if (contentType.is(MediaType.PROTOBUF)) {
            framedContentType = GrpcSerializationFormats.PROTO.mediaType();
        } else if (contentType.is(MediaType.JSON_UTF_8)) {
            framedContentType = GrpcSerializationFormats.JSON.mediaType();
        } else {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"Unsupported media type. Only application/protobuf is supported.");
        }
        grpcHeaders.contentType(framedContentType);
        if (grpcHeaders.get((CharSequence)GrpcHeaderNames.GRPC_ENCODING) != null) {
            return HttpResponse.of((HttpStatus)HttpStatus.UNSUPPORTED_MEDIA_TYPE, (MediaType)MediaType.PLAIN_TEXT_UTF_8, (String)"gRPC encoding is not supported for non-framed requests.");
        }
        grpcHeaders.remove((CharSequence)GrpcHeaderNames.GRPC_ACCEPT_ENCODING);
        ctx.logBuilder().defer(new RequestLogProperty[]{RequestLogProperty.REQUEST_CONTENT, RequestLogProperty.RESPONSE_CONTENT});
        CompletableFuture responseFuture = new CompletableFuture();
        req.aggregateWithPooledObjects((EventExecutor)ctx.eventLoop(), ctx.alloc()).handle((clientRequest, t) -> {
            if (t != null) {
                responseFuture.completeExceptionally((Throwable)t);
            } else {
                this.frameAndServe(ctx, grpcHeaders.build(), (AggregatedHttpRequest)clientRequest, responseFuture);
            }
            return null;
        });
        return HttpResponse.from(responseFuture);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void frameAndServe(ServiceRequestContext ctx, RequestHeaders grpcHeaders, AggregatedHttpRequest clientRequest, CompletableFuture<HttpResponse> res) {
        HttpResponse grpcResponse;
        HttpRequest grpcRequest;
        try (ArmeriaMessageFramer framer = new ArmeriaMessageFramer(ctx.alloc(), -1, false);){
            HttpData frame;
            HttpData content = clientRequest.content();
            boolean success = false;
            try {
                frame = framer.writePayload(content.byteBuf());
                success = true;
            }
            finally {
                if (!success) {
                    content.close();
                }
            }
            grpcRequest = HttpRequest.of((RequestHeaders)grpcHeaders, (HttpData)frame);
        }
        try {
            grpcResponse = (HttpResponse)((Service)this.unwrap()).serve(ctx, (Request)grpcRequest);
        }
        catch (Exception e) {
            res.completeExceptionally(e);
            return;
        }
        grpcResponse.aggregate().handleAsync((framedResponse, t) -> {
            if (t != null) {
                res.completeExceptionally((Throwable)t);
            } else {
                UnframedGrpcService.deframeAndRespond(ctx, framedResponse, res);
            }
            return null;
        }, (Executor)ctx.eventLoop());
    }

    private static void deframeAndRespond(ServiceRequestContext ctx, AggregatedHttpResponse grpcResponse, CompletableFuture<HttpResponse> res) {
        Object trailers = !grpcResponse.trailers().isEmpty() ? grpcResponse.trailers() : grpcResponse.headers();
        String grpcStatusCode = trailers.get((CharSequence)GrpcHeaderNames.GRPC_STATUS);
        Status grpcStatus = Status.fromCodeValue((int)Integer.parseInt(grpcStatusCode));
        if (grpcStatus.getCode() != Status.OK.getCode()) {
            HttpStatus httpStatus = GrpcStatus.grpcCodeToHttpStatus(grpcStatus.getCode());
            StringBuilder message = new StringBuilder("http-status: " + httpStatus.code());
            message.append(", ").append(httpStatus.reasonPhrase()).append('\n');
            message.append("Caused by: ").append('\n');
            message.append("grpc-status: ").append(grpcStatusCode).append(", ").append(grpcStatus.getCode().name());
            String grpcMessage = trailers.get((CharSequence)GrpcHeaderNames.GRPC_MESSAGE);
            if (grpcMessage != null) {
                message.append(", ").append(grpcMessage);
            }
            ResponseHeaders headers = ResponseHeaders.builder((HttpStatus)httpStatus).contentType(MediaType.PLAIN_TEXT_UTF_8).add((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcStatusCode).build();
            res.complete(HttpResponse.of((ResponseHeaders)headers, (HttpData)HttpData.ofUtf8((String)message.toString())));
            return;
        }
        MediaType grpcMediaType = grpcResponse.contentType();
        ResponseHeadersBuilder unframedHeaders = grpcResponse.headers().toBuilder();
        unframedHeaders.set((CharSequence)GrpcHeaderNames.GRPC_STATUS, grpcStatusCode);
        if (grpcMediaType != null) {
            if (grpcMediaType.is(GrpcSerializationFormats.PROTO.mediaType())) {
                unframedHeaders.contentType(MediaType.PROTOBUF);
            } else if (grpcMediaType.is(GrpcSerializationFormats.JSON.mediaType())) {
                unframedHeaders.contentType(MediaType.JSON_UTF_8);
            }
        }
        ArmeriaMessageDeframer deframer = new ArmeriaMessageDeframer(Integer.MAX_VALUE);
        grpcResponse.toHttpResponse().decode((HttpDecoder)deframer, ctx.alloc()).subscribe(UnframedGrpcService.singleSubscriber(unframedHeaders, res), (EventExecutor)ctx.eventLoop());
    }

    private static Subscriber<DeframedMessage> singleSubscriber(final ResponseHeadersBuilder unframedHeaders, final CompletableFuture<HttpResponse> res) {
        return new Subscriber<DeframedMessage>(){

            public void onSubscribe(Subscription subscription) {
                subscription.request(1L);
            }

            public void onNext(DeframedMessage message) {
                HttpData unframedContent = HttpData.wrap((ByteBuf)message.buf()).withEndOfStream();
                unframedHeaders.setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, unframedContent.length());
                res.complete(HttpResponse.of((ResponseHeaders)unframedHeaders.build(), (HttpData)unframedContent));
            }

            public void onError(Throwable t) {
                if (!res.isDone()) {
                    res.completeExceptionally(t);
                }
            }

            public void onComplete() {
                if (!res.isDone()) {
                    res.complete(HttpResponse.of((ResponseHeaders)unframedHeaders.build()));
                }
            }
        };
    }

    public Set<Route> routes() {
        return this.delegateGrpcService.routes();
    }
}

