/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.grpc;

import com.linecorp.armeria.client.ClientBuilderParams;
import com.linecorp.armeria.client.ClientDecoration;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.DecoratingClientFactory;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.grpc.GrpcClientOptions;
import com.linecorp.armeria.client.grpc.GrpcClientStubFactory;
import com.linecorp.armeria.client.retry.RetryingClient;
import com.linecorp.armeria.common.Scheme;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.util.Unwrappable;
import com.linecorp.armeria.internal.client.grpc.ArmeriaChannel;
import com.linecorp.armeria.internal.client.grpc.GrpcClientUtil;
import com.linecorp.armeria.internal.client.grpc.GrpcWebTrailersExtractor;
import com.linecorp.armeria.internal.client.grpc.NullGrpcClientStubFactory;
import com.linecorp.armeria.internal.server.grpc.GrpcMethodUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.grpc.Channel;
import io.grpc.ServiceDescriptor;
import io.grpc.stub.AbstractStub;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;

final class GrpcClientFactory
extends DecoratingClientFactory {
    private static final Set<Scheme> SUPPORTED_SCHEMES = (Set)Arrays.stream(SessionProtocol.values()).flatMap(p -> GrpcSerializationFormats.values().stream().map(f -> Scheme.of((SerializationFormat)f, (SessionProtocol)p))).collect(ImmutableSet.toImmutableSet());
    private static final List<GrpcClientStubFactory> clientStubFactories = ImmutableList.copyOf(ServiceLoader.load(GrpcClientStubFactory.class, GrpcClientStubFactory.class.getClassLoader()));

    GrpcClientFactory(ClientFactory httpClientFactory) {
        super(httpClientFactory);
    }

    public Set<Scheme> supportedSchemes() {
        return SUPPORTED_SCHEMES;
    }

    public Object newClient(ClientBuilderParams params) {
        this.validateParams(params);
        Scheme scheme = params.scheme();
        Class clientType = params.clientType();
        ClientOptions options = params.options();
        SerializationFormat serializationFormat = scheme.serializationFormat();
        GrpcClientStubFactory clientStubFactory = (GrpcClientStubFactory)options.get(GrpcClientOptions.GRPC_CLIENT_STUB_FACTORY);
        ServiceDescriptor serviceDescriptor = null;
        if (clientStubFactory == NullGrpcClientStubFactory.INSTANCE) {
            for (GrpcClientStubFactory stubFactory : clientStubFactories) {
                serviceDescriptor = stubFactory.findServiceDescriptor(clientType);
                if (serviceDescriptor == null) continue;
                clientStubFactory = stubFactory;
                break;
            }
        } else {
            serviceDescriptor = clientStubFactory.findServiceDescriptor(clientType);
        }
        if (serviceDescriptor == null) {
            throw GrpcClientFactory.newUnknownClientTypeException(clientType);
        }
        Map simpleMethodNames = (Map)serviceDescriptor.getMethods().stream().collect(ImmutableMap.toImmutableMap(Function.identity(), e -> GrpcMethodUtil.extractMethodName(e.getFullMethodName())));
        ClientBuilderParams newParams = GrpcClientFactory.addTrailersExtractor(params, options, serializationFormat);
        HttpClient httpClient = this.newHttpClient(newParams);
        GrpcJsonMarshaller jsonMarshaller = GrpcSerializationFormats.isJson(serializationFormat) ? (GrpcJsonMarshaller)((Function)options.get(GrpcClientOptions.GRPC_JSON_MARSHALLER_FACTORY)).apply(serviceDescriptor) : null;
        ArmeriaChannel channel = new ArmeriaChannel(newParams, httpClient, this.meterRegistry(), scheme.sessionProtocol(), serializationFormat, jsonMarshaller, simpleMethodNames);
        Object clientStub = clientStubFactory.newClientStub(clientType, channel);
        Objects.requireNonNull(clientStub, "clientStubFactory.newClientStub() returned null");
        Preconditions.checkState((boolean)clientType.isAssignableFrom(clientStub.getClass()), (String)"Unexpected client stub type: %s (expected: %s or its subtype)", (Object)clientStub.getClass().getName(), (Object)clientType.getName());
        return clientStub;
    }

    private static ClientBuilderParams addTrailersExtractor(ClientBuilderParams params, ClientOptions options, SerializationFormat serializationFormat) {
        if (!GrpcSerializationFormats.isGrpcWeb(serializationFormat)) {
            return params;
        }
        ClientDecoration originalDecoration = options.decoration();
        List decorators = originalDecoration.decorators();
        boolean foundRetryingClient = false;
        HttpClient noopClient = (ctx, req) -> null;
        for (Function decorator : decorators) {
            HttpClient decorated = (HttpClient)decorator.apply(noopClient);
            if (!(decorated instanceof RetryingClient)) continue;
            foundRetryingClient = true;
            break;
        }
        if (!foundRetryingClient) {
            return params;
        }
        GrpcWebTrailersExtractor webTrailersExtractor = new GrpcWebTrailersExtractor(GrpcClientUtil.maxInboundMessageSizeBytes(options), GrpcSerializationFormats.isGrpcWebText(serializationFormat));
        ClientOptionsBuilder optionsBuilder = options.toBuilder();
        optionsBuilder.clearDecorators();
        optionsBuilder.decorator((DecoratingHttpClientFunction)webTrailersExtractor);
        decorators.forEach(arg_0 -> ((ClientOptionsBuilder)optionsBuilder).decorator(arg_0));
        return ClientBuilderParams.of((Scheme)params.scheme(), (EndpointGroup)params.endpointGroup(), (String)params.absolutePathRef(), (Class)params.clientType(), (ClientOptions)optionsBuilder.build());
    }

    private static IllegalArgumentException newUnknownClientTypeException(Class<?> clientType) {
        return new IllegalArgumentException("Unknown client type: " + clientType.getName() + " (expected: a gRPC client stub class, e.g. MyServiceGrpc.MyServiceStub)");
    }

    public <T> T unwrap(Object client, Class<T> type) {
        Object unwrapped = super.unwrap(client, type);
        if (unwrapped != null) {
            return (T)unwrapped;
        }
        if (!(client instanceof AbstractStub)) {
            return null;
        }
        Channel ch = ((AbstractStub)client).getChannel();
        if (!(ch instanceof Unwrappable)) {
            return null;
        }
        return (T)((Unwrappable)ch).as(type);
    }
}

