/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.grpc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.internal.server.grpc.GrpcDocStringExtractor;
import com.linecorp.armeria.internal.server.grpc.GrpcMethodUtil;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.collect.HashMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.docs.DocServiceFilter;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import com.linecorp.armeria.server.grpc.GrpcService;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.protobuf.ProtoFileDescriptorSupplier;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class GrpcDocServicePlugin
implements DocServicePlugin {
    private static final String NAME = "grpc";
    @VisibleForTesting
    static final TypeSignature BOOL = TypeSignature.ofBase((String)"bool");
    @VisibleForTesting
    static final TypeSignature INT32 = TypeSignature.ofBase((String)"int32");
    @VisibleForTesting
    static final TypeSignature INT64 = TypeSignature.ofBase((String)"int64");
    @VisibleForTesting
    static final TypeSignature UINT32 = TypeSignature.ofBase((String)"uint32");
    @VisibleForTesting
    static final TypeSignature UINT64 = TypeSignature.ofBase((String)"uint64");
    @VisibleForTesting
    static final TypeSignature SINT32 = TypeSignature.ofBase((String)"sint32");
    @VisibleForTesting
    static final TypeSignature SINT64 = TypeSignature.ofBase((String)"sint64");
    @VisibleForTesting
    static final TypeSignature FLOAT = TypeSignature.ofBase((String)"float");
    @VisibleForTesting
    static final TypeSignature DOUBLE = TypeSignature.ofBase((String)"double");
    @VisibleForTesting
    static final TypeSignature FIXED32 = TypeSignature.ofBase((String)"fixed32");
    @VisibleForTesting
    static final TypeSignature FIXED64 = TypeSignature.ofBase((String)"fixed64");
    @VisibleForTesting
    static final TypeSignature SFIXED32 = TypeSignature.ofBase((String)"sfixed32");
    @VisibleForTesting
    static final TypeSignature SFIXED64 = TypeSignature.ofBase((String)"sfixed64");
    @VisibleForTesting
    static final TypeSignature STRING = TypeSignature.ofBase((String)"string");
    @VisibleForTesting
    static final TypeSignature BYTES = TypeSignature.ofBase((String)"bytes");
    @VisibleForTesting
    static final TypeSignature UNKNOWN = TypeSignature.ofBase((String)"unknown");
    private static final JsonFormat.Printer defaultExamplePrinter = JsonFormat.printer().includingDefaultValueFields();
    private final GrpcDocStringExtractor docstringExtractor = new GrpcDocStringExtractor();

    public String name() {
        return NAME;
    }

    public Set<Class<? extends Service<?, ?>>> supportedServiceTypes() {
        return ImmutableSet.of(GrpcService.class);
    }

    public ServiceSpecification generateSpecification(Set<ServiceConfig> serviceConfigs, DocServiceFilter filter) {
        Objects.requireNonNull(serviceConfigs, "serviceConfigs");
        Objects.requireNonNull(filter, "filter");
        ServiceInfosBuilder serviceInfosBuilder = new ServiceInfosBuilder();
        for (ServiceConfig serviceConfig : serviceConfigs) {
            GrpcService grpcService = (GrpcService)serviceConfig.service().as(GrpcService.class);
            assert (grpcService != null);
            ImmutableSet.Builder supportedMediaTypesBuilder = ImmutableSet.builder();
            supportedMediaTypesBuilder.addAll(grpcService.supportedSerializationFormats().stream().map(SerializationFormat::mediaType)::iterator);
            if (!grpcService.isFramed()) {
                if (grpcService.supportedSerializationFormats().contains(GrpcSerializationFormats.PROTO)) {
                    supportedMediaTypesBuilder.add((Object)MediaType.PROTOBUF.withParameter("protocol", "gRPC"));
                }
                if (grpcService.supportedSerializationFormats().contains(GrpcSerializationFormats.JSON)) {
                    supportedMediaTypesBuilder.add((Object)MediaType.JSON_UTF_8.withParameter("protocol", "gRPC"));
                }
            }
            ImmutableSet supportedMediaTypes = supportedMediaTypesBuilder.build();
            grpcService.services().stream().map(ServerServiceDefinition::getServiceDescriptor).filter(Objects::nonNull).filter(desc -> desc.getSchemaDescriptor() instanceof ProtoFileDescriptorSupplier).forEach(desc -> {
                String serviceName = desc.getName();
                ProtoFileDescriptorSupplier fileDescSupplier = (ProtoFileDescriptorSupplier)desc.getSchemaDescriptor();
                Descriptors.FileDescriptor fileDesc = fileDescSupplier.getFileDescriptor();
                Descriptors.ServiceDescriptor serviceDesc = fileDesc.getServices().stream().filter(sd -> sd.getFullName().equals(serviceName)).findFirst().orElseThrow(IllegalStateException::new);
                serviceInfosBuilder.addService(serviceDesc);
            });
            Route route = serviceConfig.route();
            String pathPrefix = route.pathType() == RoutePathType.PREFIX ? (String)route.paths().get(0) : "/";
            grpcService.methods().forEach((arg_0, arg_1) -> GrpcDocServicePlugin.lambda$generateSpecification$3(serviceConfig, pathPrefix, (Set)supportedMediaTypes, serviceInfosBuilder, arg_0, arg_1));
        }
        return this.generate(serviceInfosBuilder.build(filter));
    }

    public Map<String, String> loadDocStrings(Set<ServiceConfig> serviceConfigs) {
        return (Map)serviceConfigs.stream().flatMap(c -> {
            GrpcService grpcService = (GrpcService)c.service().as(GrpcService.class);
            assert (grpcService != null);
            return grpcService.services().stream();
        }).flatMap(s -> this.docstringExtractor.getAllDocStrings(s.getClass().getClassLoader()).entrySet().stream()).collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a));
    }

    public Set<Class<?>> supportedExampleRequestTypes() {
        return ImmutableSet.of(MessageOrBuilder.class);
    }

    public String serializeExampleRequest(String serviceName, String methodName, Object exampleRequest) {
        try {
            return defaultExamplePrinter.print((MessageOrBuilder)exampleRequest);
        }
        catch (InvalidProtocolBufferException e) {
            throw new UncheckedIOException("Invalid example request protobuf. Is it missing required fields?", (IOException)((Object)e));
        }
    }

    @VisibleForTesting
    ServiceSpecification generate(List<ServiceInfo> services) {
        return ServiceSpecification.generate(services, this::newNamedTypeInfo);
    }

    private NamedTypeInfo newNamedTypeInfo(TypeSignature typeSignature) {
        Object descriptor = typeSignature.namedTypeDescriptor();
        if (descriptor instanceof Descriptors.Descriptor) {
            return this.newStructInfo((Descriptors.Descriptor)descriptor);
        }
        assert (descriptor instanceof Descriptors.EnumDescriptor);
        return this.newEnumInfo((Descriptors.EnumDescriptor)descriptor);
    }

    @VisibleForTesting
    static MethodInfo newMethodInfo(Descriptors.MethodDescriptor method, Set<EndpointInfo> endpointInfos) {
        return new MethodInfo(method.getName(), GrpcDocServicePlugin.namedMessageSignature(method.getOutputType()), (Iterable)ImmutableList.of((Object)FieldInfo.builder((String)"request", (TypeSignature)GrpcDocServicePlugin.namedMessageSignature(method.getInputType())).requirement(FieldRequirement.REQUIRED).build()), (Iterable)ImmutableList.of(), endpointInfos, (Iterable)ImmutableList.of(), GrpcDocServicePlugin.defaultExamples(method), (Iterable)ImmutableList.of(), (Iterable)ImmutableList.of(), HttpMethod.POST, null);
    }

    private static List<String> defaultExamples(Descriptors.MethodDescriptor method) {
        try {
            DynamicMessage defaultInput = DynamicMessage.getDefaultInstance((Descriptors.Descriptor)method.getInputType());
            String serialized = defaultExamplePrinter.print((MessageOrBuilder)defaultInput).trim();
            if ("{\n}".equals(serialized) || "{}".equals(serialized)) {
                return ImmutableList.of();
            }
            return ImmutableList.of((Object)serialized);
        }
        catch (InvalidProtocolBufferException e) {
            return ImmutableList.of();
        }
    }

    @VisibleForTesting
    StructInfo newStructInfo(Descriptors.Descriptor descriptor) {
        return new StructInfo(descriptor.getFullName(), (Iterable)descriptor.getFields().stream().map(GrpcDocServicePlugin::newFieldInfo).collect(ImmutableList.toImmutableList()));
    }

    private static FieldInfo newFieldInfo(Descriptors.FieldDescriptor fieldDescriptor) {
        return FieldInfo.builder((String)fieldDescriptor.getName(), (TypeSignature)GrpcDocServicePlugin.newFieldTypeInfo(fieldDescriptor)).requirement(fieldDescriptor.isRequired() ? FieldRequirement.REQUIRED : FieldRequirement.OPTIONAL).build();
    }

    @VisibleForTesting
    static TypeSignature newFieldTypeInfo(Descriptors.FieldDescriptor fieldDescriptor) {
        TypeSignature fieldType;
        if (fieldDescriptor.isMapField()) {
            return TypeSignature.ofMap((TypeSignature)GrpcDocServicePlugin.newFieldTypeInfo(fieldDescriptor.getMessageType().findFieldByNumber(1)), (TypeSignature)GrpcDocServicePlugin.newFieldTypeInfo(fieldDescriptor.getMessageType().findFieldByNumber(2)));
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                fieldType = BOOL;
                break;
            }
            case BYTES: {
                fieldType = BYTES;
                break;
            }
            case DOUBLE: {
                fieldType = DOUBLE;
                break;
            }
            case FIXED32: {
                fieldType = FIXED32;
                break;
            }
            case FIXED64: {
                fieldType = FIXED64;
                break;
            }
            case FLOAT: {
                fieldType = FLOAT;
                break;
            }
            case INT32: {
                fieldType = INT32;
                break;
            }
            case INT64: {
                fieldType = INT64;
                break;
            }
            case SFIXED32: {
                fieldType = SFIXED32;
                break;
            }
            case SFIXED64: {
                fieldType = SFIXED64;
                break;
            }
            case SINT32: {
                fieldType = SINT32;
                break;
            }
            case SINT64: {
                fieldType = SINT64;
                break;
            }
            case STRING: {
                fieldType = STRING;
                break;
            }
            case UINT32: {
                fieldType = UINT32;
                break;
            }
            case UINT64: {
                fieldType = UINT64;
                break;
            }
            case MESSAGE: {
                fieldType = GrpcDocServicePlugin.namedMessageSignature(fieldDescriptor.getMessageType());
                break;
            }
            case GROUP: {
                fieldType = UNKNOWN;
                break;
            }
            case ENUM: {
                fieldType = TypeSignature.ofNamed((String)fieldDescriptor.getEnumType().getFullName(), (Object)fieldDescriptor.getEnumType());
                break;
            }
            default: {
                fieldType = UNKNOWN;
            }
        }
        return fieldDescriptor.isRepeated() ? TypeSignature.ofContainer((String)"repeated", (TypeSignature[])new TypeSignature[]{fieldType}) : fieldType;
    }

    @VisibleForTesting
    EnumInfo newEnumInfo(Descriptors.EnumDescriptor enumDescriptor) {
        return new EnumInfo(enumDescriptor.getFullName(), (Iterable)enumDescriptor.getValues().stream().map(d -> new EnumValueInfo(d.getName(), Integer.valueOf(d.getNumber()))).collect(ImmutableList.toImmutableList()));
    }

    private static TypeSignature namedMessageSignature(Descriptors.Descriptor descriptor) {
        return TypeSignature.ofNamed((String)descriptor.getFullName(), (Object)descriptor);
    }

    public String toString() {
        return GrpcDocServicePlugin.class.getSimpleName();
    }

    private static /* synthetic */ void lambda$generateSpecification$3(ServiceConfig serviceConfig, String pathPrefix, Set supportedMediaTypes, ServiceInfosBuilder serviceInfosBuilder, String path, ServerMethodDefinition method) {
        EndpointInfo endpointInfo = EndpointInfo.builder((String)serviceConfig.virtualHost().hostnamePattern(), (String)(pathPrefix + path)).availableMimeTypes((Iterable)supportedMediaTypes).build();
        serviceInfosBuilder.addEndpoint(method.getMethodDescriptor(), endpointInfo);
    }

    @VisibleForTesting
    static final class ServiceInfosBuilder {
        private final Map<String, Descriptors.ServiceDescriptor> services = new LinkedHashMap<String, Descriptors.ServiceDescriptor>();
        private final Multimap<Descriptors.ServiceDescriptor, Descriptors.MethodDescriptor> methods = HashMultimap.create();
        private final Multimap<Descriptors.MethodDescriptor, EndpointInfo> endpoints = HashMultimap.create();

        ServiceInfosBuilder() {
        }

        ServiceInfosBuilder addService(Descriptors.ServiceDescriptor service) {
            this.services.put(service.getFullName(), service);
            return this;
        }

        ServiceInfosBuilder addEndpoint(MethodDescriptor<?, ?> grpcMethod, EndpointInfo endpointInfo) {
            Descriptors.ServiceDescriptor service = this.services.get(grpcMethod.getServiceName());
            assert (service != null);
            Descriptors.MethodDescriptor method = service.findMethodByName(GrpcMethodUtil.extractMethodName(grpcMethod.getFullMethodName()));
            assert (method != null);
            this.methods.put((Object)service, (Object)method);
            this.endpoints.put((Object)method, (Object)endpointInfo);
            return this;
        }

        List<ServiceInfo> build(DocServiceFilter filter) {
            return (List)this.methods.asMap().entrySet().stream().map(entry -> {
                String serviceName = ((Descriptors.ServiceDescriptor)entry.getKey()).getFullName();
                List methodInfos = (List)((Collection)entry.getValue()).stream().filter(m -> filter.test(GrpcDocServicePlugin.NAME, serviceName, m.getName())).map(method -> GrpcDocServicePlugin.newMethodInfo(method, (Set<EndpointInfo>)ImmutableSet.copyOf((Collection)this.endpoints.get(method)))).collect(ImmutableList.toImmutableList());
                if (methodInfos.isEmpty()) {
                    return null;
                }
                return new ServiceInfo(serviceName, (Iterable)methodInfos);
            }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        }
    }

    @VisibleForTesting
    static final class ServiceEntry {
        final Descriptors.ServiceDescriptor service;
        final List<EndpointInfo> endpointInfos;

        ServiceEntry(Descriptors.ServiceDescriptor service, List<EndpointInfo> endpointInfos) {
            this.service = service;
            this.endpointInfos = ImmutableList.copyOf(endpointInfos);
        }

        String name() {
            return this.service.getFullName();
        }

        List<Descriptors.MethodDescriptor> methods() {
            return ImmutableList.copyOf((Collection)this.service.getMethods());
        }
    }
}

