/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.grpc.GrpcJsonMarshaller;
import com.linecorp.armeria.common.grpc.GrpcSerializationFormats;
import com.linecorp.armeria.common.grpc.GrpcStatusFunction;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.grpc.ArmeriaCoroutineContextInterceptor;
import com.linecorp.armeria.server.grpc.FramedGrpcService;
import com.linecorp.armeria.server.grpc.GrpcService;
import com.linecorp.armeria.server.grpc.HandlerRegistry;
import com.linecorp.armeria.server.grpc.ProtoReflectionServiceInterceptor;
import com.linecorp.armeria.server.grpc.UnframedGrpcService;
import io.grpc.BindableService;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerServiceDefinition;
import io.grpc.ServiceDescriptor;
import io.grpc.Status;
import io.grpc.protobuf.services.ProtoReflectionService;
import java.util.AbstractMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class GrpcServiceBuilder {
    private static final Set<SerializationFormat> DEFAULT_SUPPORTED_SERIALIZATION_FORMATS;
    private static final Logger logger;
    private static final boolean USE_COROUTINE_CONTEXT_INTERCEPTOR;
    private final HandlerRegistry.Builder registryBuilder = new HandlerRegistry.Builder();
    @Nullable
    private DecompressorRegistry decompressorRegistry;
    @Nullable
    private CompressorRegistry compressorRegistry;
    @Nullable
    private ProtoReflectionServiceInterceptor protoReflectionServiceInterceptor;
    @Nullable
    private LinkedList<Map.Entry<Class<? extends Throwable>, GrpcStatusFunction>> exceptionMappings;
    @Nullable
    private GrpcStatusFunction statusFunction;
    private Set<SerializationFormat> supportedSerializationFormats = DEFAULT_SUPPORTED_SERIALIZATION_FORMATS;
    private int maxInboundMessageSizeBytes = -1;
    private int maxOutboundMessageSizeBytes = -1;
    private Function<? super ServiceDescriptor, ? extends GrpcJsonMarshaller> jsonMarshallerFactory = GrpcJsonMarshaller::of;
    private boolean enableUnframedRequests;
    private boolean useBlockingTaskExecutor;
    private boolean unsafeWrapRequestBuffers;
    private boolean useClientTimeoutHeader = true;

    GrpcServiceBuilder() {
    }

    public GrpcServiceBuilder addService(ServerServiceDefinition service) {
        this.registryBuilder.addService(Objects.requireNonNull(service, "service"));
        return this;
    }

    public GrpcServiceBuilder addService(String path, ServerServiceDefinition service) {
        this.registryBuilder.addService(Objects.requireNonNull(path, "path"), Objects.requireNonNull(service, "service"), null);
        return this;
    }

    public GrpcServiceBuilder addService(String path, ServerServiceDefinition service, MethodDescriptor<?, ?> methodDescriptor) {
        this.registryBuilder.addService(Objects.requireNonNull(path, "path"), Objects.requireNonNull(service, "service"), Objects.requireNonNull(methodDescriptor, "methodDescriptor"));
        return this;
    }

    public GrpcServiceBuilder addService(BindableService bindableService) {
        if (bindableService instanceof ProtoReflectionService) {
            return this.addService(ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{this.newProtoReflectionServiceInterceptor()}));
        }
        return this.addService(bindableService.bindService());
    }

    public GrpcServiceBuilder addService(String path, BindableService bindableService) {
        if (bindableService instanceof ProtoReflectionService) {
            return this.addService(path, ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{this.newProtoReflectionServiceInterceptor()}));
        }
        return this.addService(path, bindableService.bindService());
    }

    public GrpcServiceBuilder addService(String path, BindableService bindableService, MethodDescriptor<?, ?> methodDescriptor) {
        if (bindableService instanceof ProtoReflectionService) {
            ServerServiceDefinition interceptor = ServerInterceptors.intercept((BindableService)bindableService, (ServerInterceptor[])new ServerInterceptor[]{this.newProtoReflectionServiceInterceptor()});
            return this.addService(path, interceptor, methodDescriptor);
        }
        return this.addService(path, bindableService.bindService(), methodDescriptor);
    }

    private ProtoReflectionServiceInterceptor newProtoReflectionServiceInterceptor() {
        Preconditions.checkState((this.protoReflectionServiceInterceptor == null ? 1 : 0) != 0, (Object)"Attempting to add a ProtoReflectionService but one is already present. ProtoReflectionService must only be added once.");
        this.protoReflectionServiceInterceptor = new ProtoReflectionServiceInterceptor();
        return this.protoReflectionServiceInterceptor;
    }

    public GrpcServiceBuilder addServices(BindableService ... bindableServices) {
        Objects.requireNonNull(bindableServices, "bindableServices");
        return this.addServices((Iterable<BindableService>)ImmutableList.copyOf((Object[])bindableServices));
    }

    public GrpcServiceBuilder addServices(Iterable<BindableService> bindableServices) {
        Objects.requireNonNull(bindableServices, "bindableServices");
        bindableServices.forEach(this::addService);
        return this;
    }

    public GrpcServiceBuilder addServiceDefinitions(ServerServiceDefinition ... services) {
        Objects.requireNonNull(services, "services");
        return this.addServiceDefinitions((Iterable<ServerServiceDefinition>)ImmutableList.copyOf((Object[])services));
    }

    public GrpcServiceBuilder addServiceDefinitions(Iterable<ServerServiceDefinition> services) {
        Objects.requireNonNull(services, "services");
        services.forEach(this::addService);
        return this;
    }

    public GrpcServiceBuilder decompressorRegistry(DecompressorRegistry registry) {
        this.decompressorRegistry = Objects.requireNonNull(registry, "registry");
        return this;
    }

    public GrpcServiceBuilder compressorRegistry(CompressorRegistry registry) {
        this.compressorRegistry = Objects.requireNonNull(registry, "registry");
        return this;
    }

    public GrpcServiceBuilder supportedSerializationFormats(SerializationFormat ... formats) {
        return this.supportedSerializationFormats((Iterable<SerializationFormat>)ImmutableSet.copyOf((Object[])Objects.requireNonNull(formats, "formats")));
    }

    public GrpcServiceBuilder supportedSerializationFormats(Iterable<SerializationFormat> formats) {
        Objects.requireNonNull(formats, "formats");
        for (SerializationFormat format : formats) {
            if (GrpcSerializationFormats.isGrpc(format)) continue;
            throw new IllegalArgumentException("Not a gRPC serialization format: " + format);
        }
        this.supportedSerializationFormats = ImmutableSet.copyOf(formats);
        return this;
    }

    public GrpcServiceBuilder setMaxInboundMessageSizeBytes(int maxInboundMessageSizeBytes) {
        Preconditions.checkArgument((maxInboundMessageSizeBytes > 0 ? 1 : 0) != 0, (Object)"maxInboundMessageSizeBytes must be >0");
        this.maxInboundMessageSizeBytes = maxInboundMessageSizeBytes;
        return this;
    }

    public GrpcServiceBuilder setMaxOutboundMessageSizeBytes(int maxOutboundMessageSizeBytes) {
        Preconditions.checkArgument((maxOutboundMessageSizeBytes > 0 ? 1 : 0) != 0, (Object)"maxOutboundMessageSizeBytes must be >0");
        this.maxOutboundMessageSizeBytes = maxOutboundMessageSizeBytes;
        return this;
    }

    public GrpcServiceBuilder enableUnframedRequests(boolean enableUnframedRequests) {
        this.enableUnframedRequests = enableUnframedRequests;
        return this;
    }

    public GrpcServiceBuilder useBlockingTaskExecutor(boolean useBlockingTaskExecutor) {
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        return this;
    }

    public GrpcServiceBuilder unsafeWrapRequestBuffers(boolean unsafeWrapRequestBuffers) {
        this.unsafeWrapRequestBuffers = unsafeWrapRequestBuffers;
        return this;
    }

    public GrpcServiceBuilder jsonMarshallerFactory(Function<? super ServiceDescriptor, ? extends GrpcJsonMarshaller> jsonMarshallerFactory) {
        this.jsonMarshallerFactory = Objects.requireNonNull(jsonMarshallerFactory, "jsonMarshallerFactory");
        return this;
    }

    public GrpcServiceBuilder useClientTimeoutHeader(boolean useClientTimeoutHeader) {
        this.useClientTimeoutHeader = useClientTimeoutHeader;
        return this;
    }

    public GrpcServiceBuilder exceptionMapping(GrpcStatusFunction statusFunction) {
        Objects.requireNonNull(statusFunction, "statusFunction");
        Preconditions.checkState((this.exceptionMappings == null ? 1 : 0) != 0, (Object)"exceptionMapping() and addExceptionMapping() are mutually exclusive.");
        this.statusFunction = statusFunction;
        return this;
    }

    public GrpcServiceBuilder addExceptionMapping(Class<? extends Throwable> exceptionType, Status status) {
        return this.addExceptionMapping(exceptionType, (T throwable, Metadata meta) -> status);
    }

    public <T extends Throwable> GrpcServiceBuilder addExceptionMapping(Class<T> exceptionType, BiFunction<T, Metadata, Status> statusFunction) {
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(statusFunction, "statusFunction");
        Preconditions.checkState((this.statusFunction == null ? 1 : 0) != 0, (Object)"addExceptionMapping() and exceptionMapping() are mutually exclusive.");
        if (this.exceptionMappings == null) {
            this.exceptionMappings = new LinkedList();
        }
        GrpcServiceBuilder.addExceptionMapping(this.exceptionMappings, exceptionType, (throwable, metadata) -> (Status)statusFunction.apply(throwable, metadata));
        return this;
    }

    @VisibleForTesting
    static <T extends Throwable> void addExceptionMapping(LinkedList<Map.Entry<Class<? extends Throwable>, GrpcStatusFunction>> exceptionMappings, Class<T> exceptionType, GrpcStatusFunction function) {
        Objects.requireNonNull(exceptionMappings, "exceptionMappings");
        Objects.requireNonNull(exceptionType, "exceptionType");
        Objects.requireNonNull(function, "function");
        ListIterator<AbstractMap.SimpleImmutableEntry<Class<T>, GrpcStatusFunction>> it = exceptionMappings.listIterator();
        while (it.hasNext()) {
            Map.Entry next = (Map.Entry)it.next();
            Class oldExceptionType = (Class)next.getKey();
            Preconditions.checkArgument((oldExceptionType != exceptionType ? 1 : 0) != 0, (String)"%s is already added with %s", (Object)oldExceptionType, next.getValue());
            if (!oldExceptionType.isAssignableFrom(exceptionType)) continue;
            it.previous();
            it.add(new AbstractMap.SimpleImmutableEntry<Class<T>, GrpcStatusFunction>(exceptionType, function));
            return;
        }
        exceptionMappings.add(new AbstractMap.SimpleImmutableEntry<Class<T>, GrpcStatusFunction>(exceptionType, function));
    }

    @VisibleForTesting
    static GrpcStatusFunction toGrpcStatusFunction(List<Map.Entry<Class<? extends Throwable>, GrpcStatusFunction>> exceptionMappings) {
        ImmutableList mappings = ImmutableList.copyOf(exceptionMappings);
        return (arg_0, arg_1) -> GrpcServiceBuilder.lambda$toGrpcStatusFunction$2((List)mappings, arg_0, arg_1);
    }

    public GrpcService build() {
        HandlerRegistry handlerRegistry;
        if (USE_COROUTINE_CONTEXT_INTERCEPTOR) {
            ArmeriaCoroutineContextInterceptor coroutineContextInterceptor = new ArmeriaCoroutineContextInterceptor(this.useBlockingTaskExecutor);
            HandlerRegistry.Builder newRegistryBuilder = new HandlerRegistry.Builder();
            for (HandlerRegistry.Entry entry : this.registryBuilder.entries()) {
                MethodDescriptor<?, ?> methodDescriptor = entry.method();
                ServerServiceDefinition intercepted = ServerInterceptors.intercept((ServerServiceDefinition)entry.service(), (ServerInterceptor[])new ServerInterceptor[]{coroutineContextInterceptor});
                newRegistryBuilder.addService(entry.path(), intercepted, methodDescriptor);
            }
            handlerRegistry = newRegistryBuilder.build();
        } else {
            handlerRegistry = this.registryBuilder.build();
        }
        GrpcStatusFunction statusFunction = this.exceptionMappings != null ? GrpcServiceBuilder.toGrpcStatusFunction(this.exceptionMappings) : this.statusFunction;
        FramedGrpcService grpcService = new FramedGrpcService(handlerRegistry, (Set)handlerRegistry.methods().keySet().stream().map(path -> Route.builder().exact('/' + path).build()).collect(ImmutableSet.toImmutableSet()), (DecompressorRegistry)MoreObjects.firstNonNull((Object)this.decompressorRegistry, (Object)DecompressorRegistry.getDefaultInstance()), (CompressorRegistry)MoreObjects.firstNonNull((Object)this.compressorRegistry, (Object)CompressorRegistry.getDefaultInstance()), this.supportedSerializationFormats, this.jsonMarshallerFactory, this.protoReflectionServiceInterceptor, statusFunction, this.maxOutboundMessageSizeBytes, this.useBlockingTaskExecutor, this.unsafeWrapRequestBuffers, this.useClientTimeoutHeader, this.maxInboundMessageSizeBytes);
        return this.enableUnframedRequests ? new UnframedGrpcService(grpcService, handlerRegistry) : grpcService;
    }

    private static /* synthetic */ Status lambda$toGrpcStatusFunction$2(List mappings, Throwable throwable, Metadata metadata) {
        for (Map.Entry mapping : mappings) {
            if (!((Class)mapping.getKey()).isInstance(throwable)) continue;
            Status status = ((GrpcStatusFunction)mapping.getValue()).apply(throwable, metadata);
            return status == null ? null : status.withCause(throwable);
        }
        return null;
    }

    static {
        boolean useCoroutineContextInterceptor;
        DEFAULT_SUPPORTED_SERIALIZATION_FORMATS = GrpcSerializationFormats.values();
        logger = LoggerFactory.getLogger(GrpcServiceBuilder.class);
        String className = "io.grpc.kotlin.CoroutineContextServerInterceptor";
        try {
            Class.forName("io.grpc.kotlin.CoroutineContextServerInterceptor", false, GrpcServiceBuilder.class.getClassLoader());
            useCoroutineContextInterceptor = true;
        }
        catch (Throwable ignored) {
            useCoroutineContextInterceptor = false;
        }
        logger.debug("{}: {}", (Object)"io.grpc.kotlin.CoroutineContextServerInterceptor", (Object)(useCoroutineContextInterceptor ? "available" : "unavailable"));
        USE_COROUTINE_CONTEXT_INTERCEPTOR = useCoroutineContextInterceptor;
    }
}

