/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.grpc;

import com.linecorp.armeria.internal.server.grpc.GrpcMethodUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class HandlerRegistry {
    private final ImmutableList<ServerServiceDefinition> services;
    private final ImmutableMap<String, ServerMethodDefinition<?, ?>> methods;
    private final ImmutableMap<MethodDescriptor<?, ?>, String> simpleMethodNames;

    private HandlerRegistry(ImmutableList<ServerServiceDefinition> services, ImmutableMap<String, ServerMethodDefinition<?, ?>> methods, ImmutableMap<MethodDescriptor<?, ?>, String> simpleMethodNames) {
        this.services = Objects.requireNonNull(services, "services");
        this.methods = Objects.requireNonNull(methods, "methods");
        this.simpleMethodNames = Objects.requireNonNull(simpleMethodNames, "simpleMethodNames");
    }

    @Nullable
    ServerMethodDefinition<?, ?> lookupMethod(String methodName) {
        return (ServerMethodDefinition)this.methods.get((Object)methodName);
    }

    String simpleMethodName(MethodDescriptor<?, ?> methodName) {
        return (String)this.simpleMethodNames.get(methodName);
    }

    List<ServerServiceDefinition> services() {
        return this.services;
    }

    Map<String, ServerMethodDefinition<?, ?>> methods() {
        return this.methods;
    }

    static final class Entry {
        private final String path;
        private final ServerServiceDefinition service;
        @Nullable
        private final MethodDescriptor<?, ?> method;

        Entry(String path, ServerServiceDefinition service, @Nullable MethodDescriptor<?, ?> method) {
            this.path = path;
            this.service = service;
            this.method = method;
        }

        String path() {
            return this.path;
        }

        ServerServiceDefinition service() {
            return this.service;
        }

        @Nullable
        MethodDescriptor<?, ?> method() {
            return this.method;
        }
    }

    static final class Builder {
        private final List<Entry> entries = new ArrayList<Entry>();

        Builder() {
        }

        Builder addService(ServerServiceDefinition service) {
            this.entries.add(new Entry(service.getServiceDescriptor().getName(), service, null));
            return this;
        }

        Builder addService(String path, ServerServiceDefinition service, @Nullable MethodDescriptor<?, ?> methodDescriptor) {
            this.entries.add(new Entry(Builder.normalizePath(path, methodDescriptor == null), service, methodDescriptor));
            return this;
        }

        private static String normalizePath(String path, boolean isServicePath) {
            int lastCharIndex;
            if (path.isEmpty()) {
                return path;
            }
            if (path.charAt(0) == '/') {
                path = path.substring(1);
            }
            if (path.isEmpty()) {
                return path;
            }
            if (isServicePath && path.charAt(lastCharIndex = path.length() - 1) == '/') {
                path = path.substring(0, lastCharIndex);
            }
            return path;
        }

        List<Entry> entries() {
            return this.entries;
        }

        HandlerRegistry build() {
            HashMap<String, ServerServiceDefinition> services = new HashMap<String, ServerServiceDefinition>();
            HashMap<String, ServerMethodDefinition> methods = new HashMap<String, ServerMethodDefinition>();
            HashMap<MethodDescriptor, String> simpleMethodNames = new HashMap<MethodDescriptor, String>();
            for (Entry entry : this.entries) {
                ServerServiceDefinition service = entry.service();
                String path = entry.path();
                services.put(path, service);
                MethodDescriptor<?, ?> methodDescriptor = entry.method();
                if (methodDescriptor == null) {
                    for (ServerMethodDefinition method : service.getMethods()) {
                        MethodDescriptor methodDescriptor0 = method.getMethodDescriptor();
                        String fullMethodName = methodDescriptor0.getFullMethodName();
                        String simpleMethodName = GrpcMethodUtil.extractMethodName(fullMethodName);
                        methods.put(path + '/' + simpleMethodName, method);
                        simpleMethodNames.put(methodDescriptor0, simpleMethodName);
                    }
                    continue;
                }
                ServerMethodDefinition method = service.getMethods().stream().filter(method0 -> method0.getMethodDescriptor() == methodDescriptor).findFirst().orElseThrow(() -> new IllegalArgumentException("Failed to retrieve " + methodDescriptor + " in " + service));
                methods.put(path, method);
                MethodDescriptor methodDescriptor0 = method.getMethodDescriptor();
                String fullMethodName = methodDescriptor0.getFullMethodName();
                simpleMethodNames.put(methodDescriptor0, GrpcMethodUtil.extractMethodName(fullMethodName));
            }
            return new HandlerRegistry(ImmutableList.copyOf(services.values()), ImmutableMap.copyOf(methods), ImmutableMap.copyOf(simpleMethodNames));
        }
    }
}

