/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.jetty;

import com.linecorp.armeria.common.util.SystemInfo;
import com.linecorp.armeria.server.Server;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.IOException;
import java.nio.channels.ServerSocketChannel;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.Future;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.ServerConnector;

final class ArmeriaConnector
extends ServerConnector {
    private static final String PROTOCOL_NAME = "armeria";
    private static final List<String> PROTOCOL_NAMES = Collections.singletonList("armeria");
    private final Server armeriaServer;
    private final HttpConfiguration httpConfig;
    private volatile boolean isShutdown;

    ArmeriaConnector(org.eclipse.jetty.server.Server server, Server armeriaServer) {
        super(server, -1, -1, new ConnectionFactory[]{new ArmeriaConnectionFactory()});
        this.armeriaServer = armeriaServer;
        HttpConfiguration httpConfig = (HttpConfiguration)server.getBean(HttpConfiguration.class);
        this.httpConfig = httpConfig != null ? httpConfig : new HttpConfiguration();
        this.addBean(this.httpConfig);
        this.setDefaultProtocol(PROTOCOL_NAME);
    }

    public Object getTransport() {
        return this;
    }

    public String getHost() {
        if (this.armeriaServer == null) {
            return SystemInfo.hostname();
        }
        return this.armeriaServer.defaultHostname();
    }

    public int getPort() {
        return this.getLocalPort();
    }

    public int getLocalPort() {
        if (this.armeriaServer == null) {
            return -1;
        }
        try {
            return this.armeriaServer.activeLocalPort();
        }
        catch (IllegalStateException e) {
            return -1;
        }
    }

    public HttpConfiguration getHttpConfiguration() {
        return this.httpConfig;
    }

    public String getName() {
        return PROTOCOL_NAME;
    }

    public boolean isOpen() {
        return !this.isShutdown();
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    public void open() {
    }

    public void open(ServerSocketChannel acceptChannel) {
        throw new UnsupportedOperationException();
    }

    protected ServerSocketChannel openAcceptChannel() throws IOException {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }

    public Future<Void> shutdown() {
        this.isShutdown = true;
        return GlobalEventExecutor.INSTANCE.newSucceededFuture(null);
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    private static final class ArmeriaConnectionFactory
    implements ConnectionFactory {
        private ArmeriaConnectionFactory() {
        }

        public String getProtocol() {
            return ArmeriaConnector.PROTOCOL_NAME;
        }

        public List<String> getProtocols() {
            return PROTOCOL_NAMES;
        }

        public Connection newConnection(Connector connector, EndPoint endPoint) {
            throw new UnsupportedOperationException();
        }
    }
}

