/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.jetty;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.jetty.ArmeriaThreadPool;
import com.linecorp.armeria.server.jetty.JettyService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;

public final class JettyServiceBuilder {
    private final ImmutableMap.Builder<String, Object> attrs = ImmutableMap.builder();
    private final ImmutableList.Builder<Bean> beans = ImmutableList.builder();
    private final ImmutableList.Builder<HandlerWrapper> handlerWrappers = ImmutableList.builder();
    private final ImmutableList.Builder<Container.Listener> eventListeners = ImmutableList.builder();
    private final ImmutableList.Builder<LifeCycle.Listener> lifeCycleListeners = ImmutableList.builder();
    private final ImmutableList.Builder<Consumer<? super Server>> customizers = ImmutableList.builder();
    @Nullable
    private String hostname;
    @Nullable
    private Boolean dumpAfterStart;
    @Nullable
    private Boolean dumpBeforeStop;
    @Nullable
    private Handler handler;
    @Nullable
    private RequestLog requestLog;
    @Nullable
    private Function<? super Server, ? extends SessionIdManager> sessionIdManagerFactory;
    @Nullable
    private Long stopTimeoutMillis;
    private boolean tlsReverseDnsLookup;

    JettyServiceBuilder() {
    }

    public JettyServiceBuilder hostname(String hostname) {
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        return this;
    }

    public JettyServiceBuilder attr(String name, Object attribute) {
        this.attrs.put((Object)Objects.requireNonNull(name, "name"), Objects.requireNonNull(attribute, "attribute"));
        return this;
    }

    public JettyServiceBuilder bean(Object bean) {
        this.beans.add((Object)new Bean(bean, null));
        return this;
    }

    public JettyServiceBuilder bean(Object bean, boolean managed) {
        this.beans.add((Object)new Bean(bean, managed));
        return this;
    }

    public JettyServiceBuilder dumpAfterStart(boolean dumpAfterStart) {
        this.dumpAfterStart = dumpAfterStart;
        return this;
    }

    public JettyServiceBuilder dumpBeforeStop(boolean dumpBeforeStop) {
        this.dumpBeforeStop = dumpBeforeStop;
        return this;
    }

    public JettyServiceBuilder handler(Handler handler) {
        this.handler = Objects.requireNonNull(handler, "handler");
        return this;
    }

    public JettyServiceBuilder handlerWrapper(HandlerWrapper handlerWrapper) {
        this.handlerWrappers.add((Object)Objects.requireNonNull(handlerWrapper, "handlerWrapper"));
        return this;
    }

    public JettyServiceBuilder httpConfiguration(HttpConfiguration httpConfiguration) {
        return this.bean(httpConfiguration);
    }

    public JettyServiceBuilder requestLog(RequestLog requestLog) {
        this.requestLog = Objects.requireNonNull(requestLog, "requestLog");
        return this;
    }

    public JettyServiceBuilder sessionIdManager(SessionIdManager sessionIdManager) {
        Objects.requireNonNull(sessionIdManager, "sessionIdManager");
        return this.sessionIdManagerFactory(server -> sessionIdManager);
    }

    public JettyServiceBuilder sessionIdManagerFactory(Function<? super Server, ? extends SessionIdManager> sessionIdManagerFactory) {
        Objects.requireNonNull(sessionIdManagerFactory, "sessionIdManagerFactory");
        this.sessionIdManagerFactory = sessionIdManagerFactory;
        return this;
    }

    public JettyServiceBuilder stopTimeoutMillis(long stopTimeoutMillis) {
        this.stopTimeoutMillis = stopTimeoutMillis;
        return this;
    }

    public JettyServiceBuilder eventListener(Container.Listener eventListener) {
        this.eventListeners.add((Object)Objects.requireNonNull(eventListener, "eventListener"));
        return this;
    }

    public JettyServiceBuilder lifeCycleListener(LifeCycle.Listener lifeCycleListener) {
        this.lifeCycleListeners.add((Object)Objects.requireNonNull(lifeCycleListener, "lifeCycleListener"));
        return this;
    }

    public JettyServiceBuilder tlsReverseDnsLookup(boolean tlsReverseDnsLookup) {
        this.tlsReverseDnsLookup = tlsReverseDnsLookup;
        return this;
    }

    public JettyServiceBuilder customizer(Consumer<? super Server> customizer) {
        this.customizers.add(Objects.requireNonNull(customizer, "customizer"));
        return this;
    }

    @Deprecated
    public JettyServiceBuilder configurator(Consumer<? super Server> configurator) {
        return this.customizer(Objects.requireNonNull(configurator, "configurator"));
    }

    public JettyService build() {
        Boolean dumpAfterStart = this.dumpAfterStart;
        Boolean dumpBeforeStop = this.dumpBeforeStop;
        Long stopTimeoutMillis = this.stopTimeoutMillis;
        Handler handler = this.handler;
        RequestLog requestLog = this.requestLog;
        Function<? super Server, ? extends SessionIdManager> sessionIdManagerFactory = this.sessionIdManagerFactory;
        ImmutableMap attrs = this.attrs.build();
        ImmutableList beans = this.beans.build();
        ImmutableList handlerWrappers = this.handlerWrappers.build();
        ImmutableList eventListeners = this.eventListeners.build();
        ImmutableList lifeCycleListeners = this.lifeCycleListeners.build();
        ImmutableList customizers = this.customizers.build();
        Function<ScheduledExecutorService, Server> serverFactory = arg_0 -> JettyServiceBuilder.lambda$build$3(dumpAfterStart, dumpBeforeStop, stopTimeoutMillis, handler, requestLog, sessionIdManagerFactory, (List)handlerWrappers, (Map)attrs, (List)beans, (List)eventListeners, (List)lifeCycleListeners, (List)customizers, arg_0);
        Consumer<Server> postStopTask = server -> {
            try {
                JettyService.logger.info("Destroying an embedded Jetty: {}", server);
                server.destroy();
            }
            catch (Exception e) {
                JettyService.logger.warn("Failed to destroy an embedded Jetty: {}", server, (Object)e);
            }
        };
        return new JettyService(this.hostname, this.tlsReverseDnsLookup, serverFactory, postStopTask);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).omitNullValues().add("hostname", (Object)this.hostname).add("dumpAfterStart", (Object)this.dumpAfterStart).add("dumpBeforeStop", (Object)this.dumpBeforeStop).add("stopTimeoutMillis", (Object)this.stopTimeoutMillis).add("handler", (Object)this.handler).add("requestLog", (Object)this.requestLog).add("sessionIdManagerFactory", this.sessionIdManagerFactory).add("attrs", this.attrs).add("beans", this.beans).add("handlerWrappers", this.handlerWrappers).add("eventListeners", this.eventListeners).add("lifeCycleListeners", this.lifeCycleListeners).add("tlsReverseDnsLookup", this.tlsReverseDnsLookup).add("customizers", this.customizers).toString();
    }

    private static /* synthetic */ Server lambda$build$3(Boolean dumpAfterStart, Boolean dumpBeforeStop, Long stopTimeoutMillis, Handler handler, RequestLog requestLog, Function sessionIdManagerFactory, List handlerWrappers, Map attrs, List beans, List eventListeners, List lifeCycleListeners, List customizers, ScheduledExecutorService blockingTaskExecutor) {
        Server server = new Server((ThreadPool)new ArmeriaThreadPool(blockingTaskExecutor));
        if (dumpAfterStart != null) {
            server.setDumpAfterStart(dumpAfterStart.booleanValue());
        }
        if (dumpBeforeStop != null) {
            server.setDumpBeforeStop(dumpBeforeStop.booleanValue());
        }
        if (stopTimeoutMillis != null) {
            server.setStopTimeout(stopTimeoutMillis.longValue());
        }
        if (handler != null) {
            server.setHandler(handler);
        }
        if (requestLog != null) {
            server.setRequestLog(requestLog);
        }
        if (sessionIdManagerFactory != null) {
            server.setSessionIdManager((SessionIdManager)sessionIdManagerFactory.apply(server));
        }
        handlerWrappers.forEach(arg_0 -> ((Server)server).insertHandler(arg_0));
        attrs.forEach((arg_0, arg_1) -> ((Server)server).setAttribute(arg_0, arg_1));
        beans.forEach(bean -> {
            Boolean managed = bean.isManaged();
            if (managed == null) {
                server.addBean(bean.bean());
            } else {
                server.addBean(bean.bean(), managed.booleanValue());
            }
        });
        eventListeners.forEach(arg_0 -> ((Server)server).addEventListener(arg_0));
        lifeCycleListeners.forEach(arg_0 -> ((Server)server).addLifeCycleListener(arg_0));
        customizers.forEach(c -> c.accept(server));
        return server;
    }

    static final class Bean {
        private final Object bean;
        @Nullable
        private final Boolean managed;

        Bean(Object bean, @Nullable Boolean managed) {
            this.bean = Objects.requireNonNull(bean, "bean");
            this.managed = managed;
        }

        Object bean() {
            return this.bean;
        }

        @Nullable
        Boolean isManaged() {
            return this.managed;
        }

        public String toString() {
            String mode = this.managed != null ? (this.managed.booleanValue() ? "managed" : "unmanaged") : "auto";
            return "(" + this.bean + ", " + mode + ')';
        }
    }
}

