/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.jetty;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.FillInterest;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.Callback;

final class ArmeriaEndPoint
implements EndPoint {
    private static final AtomicReferenceFieldUpdater<ArmeriaEndPoint, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(ArmeriaEndPoint.class, State.class, "state");
    private final ServiceRequestContext ctx;
    private final String hostname;
    @Nullable
    private volatile InetSocketAddress localAddress;
    @Nullable
    private volatile Connection connection;
    private volatile State state = State.OPEN;
    private final FillInterest fillInterest = new FillInterest(){

        protected void needsFillInterest() {
        }
    };
    private final WriteFlusher writeFlusher = new WriteFlusher(this){

        protected void onIncompleteFlush() {
        }
    };

    ArmeriaEndPoint(ServiceRequestContext ctx, @Nullable String hostname) {
        this.ctx = ctx;
        this.hostname = hostname != null ? hostname : ctx.config().virtualHost().defaultHostname();
    }

    public long getCreatedTimeStamp() {
        return this.ctx.log().partial().requestStartTimeMillis();
    }

    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress != null) {
            return localAddress;
        }
        try {
            InetSocketAddress jettyLocalAddr;
            InetSocketAddress armeriaLocalAddr = (InetSocketAddress)this.ctx.localAddress();
            this.localAddress = jettyLocalAddr = new InetSocketAddress(InetAddress.getByAddress(this.hostname, armeriaLocalAddr.getAddress().getAddress()), armeriaLocalAddr.getPort());
            return jettyLocalAddr;
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }

    public InetSocketAddress getRemoteAddress() {
        return (InetSocketAddress)this.ctx.remoteAddress();
    }

    @Nullable
    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public boolean isOptimizedForDirectBuffers() {
        return false;
    }

    @Nullable
    public Object getTransport() {
        return null;
    }

    public long getIdleTimeout() {
        return 0L;
    }

    public void setIdleTimeout(long idleTimeout) {
    }

    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    public boolean isInputShutdown() {
        return this.state == State.CLOSED;
    }

    public boolean isOutputShutdown() {
        return this.state != State.OPEN;
    }

    public void shutdownOutput() {
        stateUpdater.compareAndSet(this, State.OPEN, State.OUTPUT_SHUTDOWN);
    }

    public void close() {
        this.close(null);
    }

    private void close(@Nullable Throwable failure) {
        State oldState;
        while ((oldState = this.state) != State.CLOSED) {
            if (!stateUpdater.compareAndSet(this, oldState, State.CLOSED)) continue;
            if (failure == null) {
                this.onClose();
                continue;
            }
            this.onClose(failure);
        }
    }

    public void onOpen() {
    }

    public void onClose() {
        this.writeFlusher.onClose();
        this.fillInterest.onClose();
    }

    private void onClose(Throwable failure) {
        this.writeFlusher.onFail(failure);
        this.fillInterest.onFail(failure);
    }

    public int fill(ByteBuffer buffer) {
        return 0;
    }

    public boolean flush(ByteBuffer ... buffer) {
        return true;
    }

    public void fillInterested(Callback callback) {
        this.fillInterest.register(callback);
    }

    public boolean tryFillInterested(Callback callback) {
        return this.fillInterest.tryRegister(callback);
    }

    public boolean isFillInterested() {
        return this.fillInterest.isInterested();
    }

    public void write(Callback callback, ByteBuffer ... buffers) {
        this.writeFlusher.write(callback, buffers);
    }

    public void upgrade(Connection newConnection) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.ctx).toString();
    }

    private static enum State {
        OPEN,
        OUTPUT_SHUTDOWN,
        CLOSED;

    }
}

