/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.jetty;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpResponseWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.CompletionActions;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.server.servlet.ServletTlsAttributes;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerListener;
import com.linecorp.armeria.server.ServerListenerAdapter;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.jetty.ArmeriaConnector;
import com.linecorp.armeria.server.jetty.ArmeriaEndPoint;
import com.linecorp.armeria.server.jetty.JettyServiceBuilder;
import io.netty.buffer.ByteBuf;
import io.netty.util.AsciiString;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLSession;
import javax.servlet.DispatcherType;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpInput;
import org.eclipse.jetty.server.HttpTransport;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JettyService
implements HttpService {
    static final Logger logger = LoggerFactory.getLogger(JettyService.class);
    private static final MethodHandle jReqSetAsyncSupported;
    @Nullable
    private static final MethodHandle jResGetTrailerSupplier;
    private final Function<ScheduledExecutorService, org.eclipse.jetty.server.Server> serverFactory;
    private final Consumer<org.eclipse.jetty.server.Server> postStopTask;
    private final Configurator configurator;
    @Nullable
    private final String hostname;
    private final boolean tlsReverseDnsLookup;
    @Nullable
    private org.eclipse.jetty.server.Server server;
    @Nullable
    private ArmeriaConnector connector;
    @Nullable
    private Server armeriaServer;
    private boolean startedServer;

    public static JettyService of(org.eclipse.jetty.server.Server jettyServer) {
        return JettyService.of(jettyServer, null);
    }

    public static JettyService of(org.eclipse.jetty.server.Server jettyServer, @Nullable String hostname) {
        return JettyService.of(jettyServer, hostname, false);
    }

    public static JettyService of(org.eclipse.jetty.server.Server jettyServer, @Nullable String hostname, boolean tlsReverseDnsLookup) {
        Objects.requireNonNull(jettyServer, "jettyServer");
        return new JettyService(hostname, tlsReverseDnsLookup, blockingTaskExecutor -> jettyServer);
    }

    public static JettyServiceBuilder builder() {
        return new JettyServiceBuilder();
    }

    private JettyService(@Nullable String hostname, boolean tlsReverseDnsLookup, Function<ScheduledExecutorService, org.eclipse.jetty.server.Server> serverSupplier) {
        this(hostname, tlsReverseDnsLookup, serverSupplier, unused -> {});
    }

    JettyService(@Nullable String hostname, boolean tlsReverseDnsLookup, Function<ScheduledExecutorService, org.eclipse.jetty.server.Server> serverFactory, Consumer<org.eclipse.jetty.server.Server> postStopTask) {
        this.hostname = hostname;
        this.tlsReverseDnsLookup = tlsReverseDnsLookup;
        this.serverFactory = serverFactory;
        this.postStopTask = postStopTask;
        this.configurator = new Configurator();
    }

    public void serviceAdded(ServiceConfig cfg) {
        if (this.armeriaServer != null) {
            if (this.armeriaServer != cfg.server()) {
                throw new IllegalStateException("cannot be added to more than one server");
            }
            return;
        }
        this.armeriaServer = cfg.server();
        this.armeriaServer.addListener((ServerListener)this.configurator);
    }

    void start() throws Exception {
        boolean success = false;
        try {
            assert (this.armeriaServer != null);
            this.server = this.serverFactory.apply(this.armeriaServer.config().blockingTaskExecutor());
            this.connector = new ArmeriaConnector(this.server, this.armeriaServer);
            this.server.addConnector((Connector)this.connector);
            if (!this.server.isRunning()) {
                logger.info("Starting an embedded Jetty: {}", (Object)this.server);
                this.server.start();
                this.startedServer = true;
            } else {
                this.startedServer = false;
            }
            success = true;
        }
        finally {
            if (!success) {
                this.server = null;
                this.connector = null;
            }
        }
    }

    void stop() {
        org.eclipse.jetty.server.Server server = this.server;
        this.server = null;
        this.connector = null;
        if (server == null || !this.startedServer) {
            return;
        }
        try {
            logger.info("Stopping an embedded Jetty: {}", (Object)server);
            server.stop();
        }
        catch (Exception e) {
            logger.warn("Failed to stop an embedded Jetty: {}", (Object)server, (Object)e);
        }
        this.postStopTask.accept(server);
    }

    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) {
        ArmeriaConnector connector = this.connector;
        assert (connector != null);
        HttpResponseWriter res = HttpResponse.streaming();
        ((CompletableFuture)req.aggregate().handle((aReq, cause) -> {
            if (cause != null) {
                logger.warn("{} Failed to aggregate a request:", (Object)ctx, cause);
                if (res.tryWrite((Object)ResponseHeaders.of((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR))) {
                    res.close();
                }
                return null;
            }
            boolean success = false;
            try {
                boolean needsReverseDnsLookup;
                ArmeriaHttpTransport transport = new ArmeriaHttpTransport(ctx, res);
                HttpChannel httpChannel = new HttpChannel((Connector)connector, connector.getHttpConfiguration(), (EndPoint)new ArmeriaEndPoint(ctx, this.hostname), (HttpTransport)transport);
                httpChannel.getState().setTimeout(0L);
                ctx.whenRequestCancelling().handle((cancellationCause, unused) -> {
                    httpChannel.abort(cancellationCause);
                    return null;
                });
                Request jReq = httpChannel.getRequest();
                JettyService.fillRequest(ctx, aReq, jReq);
                SSLSession sslSession = ctx.sslSession();
                if (sslSession != null) {
                    needsReverseDnsLookup = this.tlsReverseDnsLookup;
                    ServletTlsAttributes.fill((SSLSession)sslSession, (arg_0, arg_1) -> ((Request)jReq).setAttribute(arg_0, arg_1));
                } else {
                    needsReverseDnsLookup = false;
                }
                ctx.blockingTaskExecutor().execute(() -> {
                    if (needsReverseDnsLookup) {
                        try {
                            ((InetSocketAddress)ctx.remoteAddress()).getHostName();
                        }
                        catch (Throwable t) {
                            logger.warn("{} Failed to perform a reverse DNS lookup:", (Object)ctx, (Object)t);
                        }
                    }
                    try {
                        httpChannel.handle();
                    }
                    catch (Throwable t) {
                        logger.warn("{} Failed to handle a request:", (Object)ctx, (Object)t);
                    }
                });
                success = true;
                Object var12_12 = null;
                return var12_12;
            }
            finally {
                if (!success) {
                    res.close();
                }
            }
        })).exceptionally(CompletionActions::log);
        return res;
    }

    public ExchangeType exchangeType(RequestHeaders headers, Route route) {
        return ExchangeType.RESPONSE_STREAMING;
    }

    private static void fillRequest(ServiceRequestContext ctx, AggregatedHttpRequest aReq, Request jReq) {
        jReq.setDispatcherType(DispatcherType.REQUEST);
        try {
            jReqSetAsyncSupported.invoke(jReq, true, "armeria");
        }
        catch (Throwable t) {
            Exceptions.throwUnsafely((Throwable)t);
        }
        jReq.setSecure(ctx.sessionProtocol().isTls());
        jReq.setMetaData(JettyService.toRequestMetadata(ctx, aReq));
        HttpData content = aReq.content();
        if (!content.isEmpty()) {
            ByteBuf buf = content.byteBuf();
            ByteBuffer nioBuf = buf.nioBufferCount() == 1 ? buf.nioBuffer() : ByteBuffer.wrap(content.array());
            jReq.getHttpInput().addContent(new HttpInput.Content(nioBuf));
        }
        jReq.getHttpInput().eof();
    }

    private static MetaData.Request toRequestMetadata(ServiceRequestContext ctx, AggregatedHttpRequest aReq) {
        StringBuilder uriBuf = new StringBuilder();
        RequestHeaders aHeaders = aReq.headers();
        uriBuf.append(ctx.sessionProtocol().isTls() ? "https" : "http");
        uriBuf.append("://");
        uriBuf.append(aHeaders.authority());
        uriBuf.append(aHeaders.path());
        HttpURI uri = new HttpURI(uriBuf.toString());
        uri.setPath(ctx.mappedPath());
        HttpFields jHeaders = new HttpFields(aHeaders.size());
        aHeaders.forEach(e -> {
            AsciiString key = (AsciiString)e.getKey();
            if (key.isEmpty()) {
                return;
            }
            if (key.byteAt(0) != 58) {
                jHeaders.add(key.toString(), (String)e.getValue());
            } else if (HttpHeaderNames.AUTHORITY.equals((Object)key) && !aHeaders.contains((CharSequence)HttpHeaderNames.HOST)) {
                jHeaders.add(HttpHeaderNames.HOST.toString(), (String)e.getValue());
            }
        });
        return new MetaData.Request(aHeaders.get((CharSequence)HttpHeaderNames.METHOD), uri, ctx.sessionProtocol().isMultiplex() ? HttpVersion.HTTP_2 : HttpVersion.HTTP_1_1, jHeaders, (long)aReq.content().length());
    }

    static {
        MethodHandle setAsyncSupported = null;
        try {
            setAsyncSupported = MethodHandles.lookup().unreflect(Request.class.getMethod("setAsyncSupported", Boolean.TYPE, Object.class));
        }
        catch (Throwable t) {
            try {
                setAsyncSupported = MethodHandles.lookup().unreflect(Request.class.getMethod("setAsyncSupported", Boolean.TYPE, String.class));
            }
            catch (Throwable t2) {
                t2.addSuppressed(t);
                Exceptions.throwUnsafely((Throwable)t2);
            }
        }
        assert (setAsyncSupported != null);
        jReqSetAsyncSupported = setAsyncSupported;
        MethodHandle getTrailerSupplier = null;
        try {
            getTrailerSupplier = MethodHandles.lookup().unreflect(MetaData.Response.class.getMethod("getTrailerSupplier", new Class[0]));
        }
        catch (Throwable t) {
            getTrailerSupplier = null;
        }
        jResGetTrailerSupplier = getTrailerSupplier;
    }

    private final class Configurator
    extends ServerListenerAdapter {
        private Configurator() {
        }

        public void serverStarting(Server server) throws Exception {
            JettyService.this.start();
        }

        public void serverStopped(Server server) throws Exception {
            JettyService.this.stop();
        }
    }

    private static final class ArmeriaHttpTransport
    implements HttpTransport {
        private final ServiceRequestContext ctx;
        private final HttpResponseWriter res;
        @Nullable
        MetaData.Response info;

        ArmeriaHttpTransport(ServiceRequestContext ctx, HttpResponseWriter res) {
            this.ctx = ctx;
            this.res = res;
        }

        public void send(@Nullable MetaData.Response info, boolean head, @Nullable ByteBuffer content, boolean lastContent, Callback callback) {
            if (this.ctx.isTimedOut()) {
                callback.succeeded();
                return;
            }
            try {
                int length;
                if (info != null) {
                    this.info = info;
                    this.write((HttpObject)ArmeriaHttpTransport.toResponseHeaders(info));
                }
                int n = length = content != null ? content.remaining() : 0;
                if (!head && length != 0) {
                    HttpData data;
                    if (content.hasArray()) {
                        int from = content.arrayOffset() + content.position();
                        content.position(content.position() + length);
                        data = HttpData.wrap((byte[])Arrays.copyOfRange(content.array(), from, from + length));
                    } else {
                        byte[] buf = new byte[length];
                        content.get(buf);
                        data = HttpData.wrap((byte[])buf);
                    }
                    if (lastContent) {
                        HttpHeaders trailers = this.toResponseTrailers(info);
                        if (trailers != null) {
                            this.write((HttpObject)data);
                            this.write((HttpObject)trailers);
                        } else {
                            this.write((HttpObject)data.withEndOfStream());
                        }
                        this.res.close();
                    } else {
                        this.write((HttpObject)data);
                    }
                } else if (lastContent) {
                    HttpHeaders trailers = this.toResponseTrailers(info);
                    if (trailers != null) {
                        this.write((HttpObject)trailers);
                    }
                    this.res.close();
                }
                callback.succeeded();
            }
            catch (Throwable cause) {
                callback.failed(cause);
            }
        }

        private void write(HttpObject o) {
            this.res.tryWrite((Object)o);
        }

        private static ResponseHeaders toResponseHeaders(MetaData.Response info) {
            ResponseHeadersBuilder headers = ResponseHeaders.builder();
            headers.status(info.getStatus());
            info.getFields().forEach(e -> headers.add((CharSequence)HttpHeaderNames.of((CharSequence)e.getName()), e.getValue()));
            return headers.build();
        }

        @Nullable
        private HttpHeaders toResponseTrailers(@Nullable MetaData.Response info) {
            Supplier trailerSupplier;
            if (jResGetTrailerSupplier == null) {
                return null;
            }
            if (info == null && (info = this.info) == null) {
                return null;
            }
            try {
                trailerSupplier = jResGetTrailerSupplier.invoke(info);
            }
            catch (Throwable t) {
                return (HttpHeaders)Exceptions.throwUnsafely((Throwable)t);
            }
            if (trailerSupplier == null) {
                return null;
            }
            HttpFields fields = (HttpFields)trailerSupplier.get();
            if (fields == null || fields.size() == 0) {
                return null;
            }
            HttpHeadersBuilder headers = HttpHeaders.builder();
            fields.forEach(e -> headers.add((CharSequence)HttpHeaderNames.of((CharSequence)e.getName()), e.getValue()));
            return headers.build();
        }

        public boolean isPushSupported() {
            return false;
        }

        public void push(MetaData.Request request) {
        }

        public void onCompleted() {
            this.res.close();
        }

        public void abort(Throwable failure) {
            this.res.close(failure);
        }

        public boolean isOptimizedForDirectBuffers() {
            return false;
        }
    }
}

