/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.jetty;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.FillInterest;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.util.Callback;

abstract class AbstractArmeriaEndPoint
implements EndPoint {
    private static final AtomicReferenceFieldUpdater<AbstractArmeriaEndPoint, State> stateUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractArmeriaEndPoint.class, State.class, "state");
    private final ServiceRequestContext ctx;
    private final String hostname;
    @Nullable
    private volatile InetSocketAddress localAddress;
    @Nullable
    private volatile Connection connection;
    private volatile State state = State.OPEN;
    private final FillInterest fillInterest = new FillInterest(){

        protected void needsFillInterest() {
        }
    };
    private final WriteFlusher writeFlusher = new WriteFlusher(this){

        protected void onIncompleteFlush() {
        }
    };

    AbstractArmeriaEndPoint(ServiceRequestContext ctx, @Nullable String hostname) {
        this.ctx = ctx;
        this.hostname = hostname != null ? hostname : ctx.config().virtualHost().defaultHostname();
    }

    public long getCreatedTimeStamp() {
        return this.ctx.log().partial().requestStartTimeMillis();
    }

    public InetSocketAddress getLocalAddress() {
        InetSocketAddress localAddress = this.localAddress;
        if (localAddress != null) {
            return localAddress;
        }
        try {
            InetSocketAddress jettyLocalAddr;
            InetSocketAddress armeriaLocalAddr = this.ctx.localAddress();
            this.localAddress = jettyLocalAddr = new InetSocketAddress(InetAddress.getByAddress(this.hostname, armeriaLocalAddr.getAddress().getAddress()), armeriaLocalAddr.getPort());
            return jettyLocalAddr;
        }
        catch (UnknownHostException e) {
            throw new Error(e);
        }
    }

    public InetSocketAddress getRemoteAddress() {
        return this.ctx.remoteAddress();
    }

    @Nullable
    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    @Nullable
    public Object getTransport() {
        return null;
    }

    public long getIdleTimeout() {
        return 0L;
    }

    public void setIdleTimeout(long idleTimeout) {
    }

    public boolean isOpen() {
        return this.state != State.CLOSED;
    }

    public boolean isInputShutdown() {
        return this.state == State.CLOSED;
    }

    public boolean isOutputShutdown() {
        return this.state != State.OPEN;
    }

    public void shutdownOutput() {
        stateUpdater.compareAndSet(this, State.OPEN, State.OUTPUT_SHUTDOWN);
    }

    public void close() {
        this.close0(null);
    }

    void close0(@Nullable Throwable failure) {
        State oldState;
        while ((oldState = this.state) != State.CLOSED) {
            if (!stateUpdater.compareAndSet(this, oldState, State.CLOSED)) continue;
            this.onClose0(failure);
        }
    }

    public void onOpen() {
    }

    void onClose0(@Nullable Throwable failure) {
        if (failure == null) {
            this.writeFlusher.onClose();
            this.fillInterest.onClose();
        } else {
            this.writeFlusher.onFail(failure);
            this.fillInterest.onFail(failure);
        }
    }

    public int fill(ByteBuffer buffer) {
        return 0;
    }

    public boolean flush(ByteBuffer ... buffer) {
        return true;
    }

    public void fillInterested(Callback callback) {
        this.fillInterest.register(callback);
    }

    public boolean tryFillInterested(Callback callback) {
        return this.fillInterest.tryRegister(callback);
    }

    public boolean isFillInterested() {
        return this.fillInterest.isInterested();
    }

    public void write(Callback callback, ByteBuffer ... buffers) {
        this.writeFlusher.write(callback, buffers);
    }

    public void upgrade(Connection newConnection) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).addValue((Object)this.ctx).toString();
    }

    private static enum State {
        OPEN,
        OUTPUT_SHUTDOWN,
        CLOSED;

    }
}

