/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.jetty;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.server.jetty.AbstractJettyServiceBuilder;
import com.linecorp.armeria.server.jetty.ArmeriaThreadPool;
import com.linecorp.armeria.server.jetty.JettyService;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.SessionIdManager;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.util.component.Container;
import org.eclipse.jetty.util.component.LifeCycle;
import org.eclipse.jetty.util.thread.ThreadPool;

public final class JettyServiceBuilder
extends AbstractJettyServiceBuilder {
    private final ImmutableList.Builder<Container.Listener> eventListeners = ImmutableList.builder();
    private final ImmutableList.Builder<LifeCycle.Listener> lifeCycleListeners = ImmutableList.builder();
    private final ImmutableList.Builder<HandlerWrapper> handlerWrappers = ImmutableList.builder();
    @Nullable
    private Function<? super Server, ? extends SessionIdManager> sessionIdManagerFactory;
    private boolean tlsReverseDnsLookup;

    JettyServiceBuilder() {
    }

    public JettyServiceBuilder eventListener(Container.Listener eventListener) {
        this.eventListeners.add((Object)Objects.requireNonNull(eventListener, "eventListener"));
        return this;
    }

    public JettyServiceBuilder lifeCycleListener(LifeCycle.Listener lifeCycleListener) {
        this.lifeCycleListeners.add((Object)Objects.requireNonNull(lifeCycleListener, "lifeCycleListener"));
        return this;
    }

    @Override
    public JettyServiceBuilder hostname(String hostname) {
        return (JettyServiceBuilder)super.hostname(hostname);
    }

    @Override
    public JettyServiceBuilder attr(String name, Object attribute) {
        return (JettyServiceBuilder)super.attr(name, attribute);
    }

    @Override
    public JettyServiceBuilder bean(Object bean) {
        return (JettyServiceBuilder)super.bean(bean);
    }

    @Override
    public JettyServiceBuilder bean(Object bean, boolean managed) {
        return (JettyServiceBuilder)super.bean(bean, managed);
    }

    @Override
    public JettyServiceBuilder dumpAfterStart(boolean dumpAfterStart) {
        return (JettyServiceBuilder)super.dumpAfterStart(dumpAfterStart);
    }

    @Override
    public JettyServiceBuilder dumpBeforeStop(boolean dumpBeforeStop) {
        return (JettyServiceBuilder)super.dumpBeforeStop(dumpBeforeStop);
    }

    @Override
    public JettyServiceBuilder handler(Handler handler) {
        return (JettyServiceBuilder)super.handler(handler);
    }

    public JettyServiceBuilder handlerWrapper(HandlerWrapper handlerWrapper) {
        this.handlerWrappers.add((Object)Objects.requireNonNull(handlerWrapper, "handlerWrapper"));
        return this;
    }

    @Override
    public JettyServiceBuilder httpConfiguration(HttpConfiguration httpConfiguration) {
        return (JettyServiceBuilder)super.httpConfiguration(httpConfiguration);
    }

    @Override
    public JettyServiceBuilder requestLog(RequestLog requestLog) {
        return (JettyServiceBuilder)super.requestLog(requestLog);
    }

    public JettyServiceBuilder sessionIdManager(SessionIdManager sessionIdManager) {
        Objects.requireNonNull(sessionIdManager, "sessionIdManager");
        return this.sessionIdManagerFactory(server -> sessionIdManager);
    }

    public JettyServiceBuilder sessionIdManagerFactory(Function<? super Server, ? extends SessionIdManager> sessionIdManagerFactory) {
        Objects.requireNonNull(sessionIdManagerFactory, "sessionIdManagerFactory");
        this.sessionIdManagerFactory = sessionIdManagerFactory;
        return this;
    }

    @Override
    public JettyServiceBuilder stopTimeoutMillis(long stopTimeoutMillis) {
        return (JettyServiceBuilder)super.stopTimeoutMillis(stopTimeoutMillis);
    }

    public JettyServiceBuilder tlsReverseDnsLookup(boolean tlsReverseDnsLookup) {
        this.tlsReverseDnsLookup = tlsReverseDnsLookup;
        return this;
    }

    @Override
    public JettyServiceBuilder customizer(Consumer<? super Server> customizer) {
        return (JettyServiceBuilder)super.customizer(customizer);
    }

    @Override
    public JettyServiceBuilder configurator(Consumer<? super Server> configurator) {
        return (JettyServiceBuilder)super.configurator(configurator);
    }

    public JettyService build() {
        Boolean dumpAfterStart = this.dumpAfterStart;
        Boolean dumpBeforeStop = this.dumpBeforeStop;
        Long stopTimeoutMillis = this.stopTimeoutMillis;
        Handler handler = this.handler;
        RequestLog requestLog = this.requestLog;
        Function<? super Server, ? extends SessionIdManager> sessionIdManagerFactory = this.sessionIdManagerFactory;
        ImmutableMap attrs = this.attrs.build();
        ImmutableList beans = this.beans.build();
        ImmutableList handlerWrappers = this.handlerWrappers.build();
        ImmutableList eventListeners = this.eventListeners.build();
        ImmutableList lifeCycleListeners = this.lifeCycleListeners.build();
        ImmutableList customizers = this.customizers.build();
        Function<BlockingTaskExecutor, Server> serverFactory = arg_0 -> JettyServiceBuilder.lambda$build$3(dumpAfterStart, dumpBeforeStop, stopTimeoutMillis, handler, requestLog, sessionIdManagerFactory, (List)handlerWrappers, (Map)attrs, (List)beans, (List)eventListeners, (List)lifeCycleListeners, (List)customizers, arg_0);
        Consumer<Server> postStopTask = server -> {
            try {
                JettyService.logger.info("Destroying an embedded Jetty: {}", server);
                server.destroy();
            }
            catch (Exception e) {
                JettyService.logger.warn("Failed to destroy an embedded Jetty: {}", server, (Object)e);
            }
        };
        return new JettyService(this.hostname, this.tlsReverseDnsLookup, serverFactory, postStopTask);
    }

    private static /* synthetic */ Server lambda$build$3(Boolean dumpAfterStart, Boolean dumpBeforeStop, Long stopTimeoutMillis, Handler handler, RequestLog requestLog, Function sessionIdManagerFactory, List handlerWrappers, Map attrs, List beans, List eventListeners, List lifeCycleListeners, List customizers, BlockingTaskExecutor blockingTaskExecutor) {
        Server server = new Server((ThreadPool)new ArmeriaThreadPool(blockingTaskExecutor));
        if (dumpAfterStart != null) {
            server.setDumpAfterStart(dumpAfterStart.booleanValue());
        }
        if (dumpBeforeStop != null) {
            server.setDumpBeforeStop(dumpBeforeStop.booleanValue());
        }
        if (stopTimeoutMillis != null) {
            server.setStopTimeout(stopTimeoutMillis.longValue());
        }
        if (handler != null) {
            server.setHandler(handler);
        }
        if (requestLog != null) {
            server.setRequestLog(requestLog);
        }
        if (sessionIdManagerFactory != null) {
            server.setSessionIdManager((SessionIdManager)sessionIdManagerFactory.apply(server));
        }
        handlerWrappers.forEach(arg_0 -> ((Server)server).insertHandler(arg_0));
        attrs.forEach((arg_0, arg_1) -> ((Server)server).setAttribute(arg_0, arg_1));
        beans.forEach(bean -> {
            Boolean managed = bean.isManaged();
            if (managed == null) {
                server.addBean(bean.bean());
            } else {
                server.addBean(bean.bean(), managed.booleanValue());
            }
        });
        eventListeners.forEach(arg_0 -> ((Server)server).addEventListener(arg_0));
        lifeCycleListeners.forEach(arg_0 -> ((Server)server).addLifeCycleListener(arg_0));
        customizers.forEach(c -> c.accept(server));
        return server;
    }
}

