/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.jetty;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Objects;
import java.util.function.Consumer;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Server;

public abstract class AbstractJettyServiceBuilder {
    final ImmutableMap.Builder<String, Object> attrs = ImmutableMap.builder();
    final ImmutableList.Builder<Bean> beans = ImmutableList.builder();
    final ImmutableList.Builder<Consumer<? super Server>> customizers = ImmutableList.builder();
    @Nullable
    String hostname;
    @Nullable
    Boolean dumpAfterStart;
    @Nullable
    Boolean dumpBeforeStop;
    @Nullable
    Handler handler;
    @Nullable
    RequestLog requestLog;
    @Nullable
    Long stopTimeoutMillis;

    AbstractJettyServiceBuilder() {
    }

    public AbstractJettyServiceBuilder hostname(String hostname) {
        this.hostname = Objects.requireNonNull(hostname, "hostname");
        return this;
    }

    public AbstractJettyServiceBuilder attr(String name, Object attribute) {
        this.attrs.put((Object)Objects.requireNonNull(name, "name"), Objects.requireNonNull(attribute, "attribute"));
        return this;
    }

    public AbstractJettyServiceBuilder bean(Object bean) {
        this.beans.add((Object)new Bean(bean, null));
        return this;
    }

    public AbstractJettyServiceBuilder bean(Object bean, boolean managed) {
        this.beans.add((Object)new Bean(bean, managed));
        return this;
    }

    public AbstractJettyServiceBuilder dumpAfterStart(boolean dumpAfterStart) {
        this.dumpAfterStart = dumpAfterStart;
        return this;
    }

    public AbstractJettyServiceBuilder dumpBeforeStop(boolean dumpBeforeStop) {
        this.dumpBeforeStop = dumpBeforeStop;
        return this;
    }

    public AbstractJettyServiceBuilder handler(Handler handler) {
        this.handler = Objects.requireNonNull(handler, "handler");
        return this;
    }

    public AbstractJettyServiceBuilder httpConfiguration(HttpConfiguration httpConfiguration) {
        return this.bean(httpConfiguration);
    }

    public AbstractJettyServiceBuilder requestLog(RequestLog requestLog) {
        this.requestLog = Objects.requireNonNull(requestLog, "requestLog");
        return this;
    }

    public AbstractJettyServiceBuilder stopTimeoutMillis(long stopTimeoutMillis) {
        this.stopTimeoutMillis = stopTimeoutMillis;
        return this;
    }

    public AbstractJettyServiceBuilder customizer(Consumer<? super Server> customizer) {
        this.customizers.add(Objects.requireNonNull(customizer, "customizer"));
        return this;
    }

    @Deprecated
    public AbstractJettyServiceBuilder configurator(Consumer<? super Server> configurator) {
        return this.customizer(Objects.requireNonNull(configurator, "configurator"));
    }

    static final class Bean {
        private final Object bean;
        @Nullable
        private final Boolean managed;

        Bean(Object bean, @Nullable Boolean managed) {
            this.bean = Objects.requireNonNull(bean, "bean");
            this.managed = managed;
        }

        Object bean() {
            return this.bean;
        }

        @Nullable
        Boolean isManaged() {
            return this.managed;
        }

        public String toString() {
            String mode = this.managed != null ? (this.managed.booleanValue() ? "managed" : "unmanaged") : "auto";
            return "(" + this.bean + ", " + mode + ')';
        }
    }
}

