/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.testing.server;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public final class ServiceRequestContextCaptor {
    private static final int DEFAULT_TIMEOUT_IN_SECONDS = 15;
    private final BlockingQueue<ServiceRequestContext> serviceContexts = new LinkedBlockingDeque<ServiceRequestContext>();

    public Function<? super HttpService, ? extends HttpService> newDecorator() {
        return delegate -> new SimpleDecoratingHttpService((HttpService)delegate, (HttpService)delegate){
            final /* synthetic */ HttpService val$delegate;
            {
                this.val$delegate = httpService;
                super(delegate);
            }

            public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
                ServiceRequestContextCaptor.this.serviceContexts.add(ctx);
                return this.val$delegate.serve(ctx, req);
            }
        };
    }

    public Function<? super HttpService, ? extends HttpService> newDecorator(final Predicate<? super ServiceRequestContext> filter) {
        Objects.requireNonNull(filter, "filter");
        return delegate -> new SimpleDecoratingHttpService((HttpService)delegate, (HttpService)delegate){
            final /* synthetic */ HttpService val$delegate;
            {
                this.val$delegate = httpService;
                super(delegate);
            }

            public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
                if (filter.test(ctx)) {
                    ServiceRequestContextCaptor.this.serviceContexts.add(ctx);
                }
                return this.val$delegate.serve(ctx, req);
            }
        };
    }

    public void clear() {
        this.serviceContexts.clear();
    }

    public int size() {
        return this.serviceContexts.size();
    }

    public ServiceRequestContext take() throws InterruptedException {
        return this.serviceContexts.take();
    }

    @Nullable
    public ServiceRequestContext poll() throws InterruptedException {
        return this.poll(15L, TimeUnit.SECONDS);
    }

    @Nullable
    public ServiceRequestContext poll(long timeout, TimeUnit unit) throws InterruptedException {
        return this.serviceContexts.poll(timeout, unit);
    }

    public boolean isEmpty() {
        return this.serviceContexts.isEmpty();
    }
}

