/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.testing;

import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public abstract class ServerRuleDelegate {
    private final AtomicReference<Server> server = new AtomicReference();
    private final boolean autoStart;

    protected ServerRuleDelegate(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void before() throws Throwable {
        if (this.autoStart) {
            this.start();
        }
    }

    public void after() {
        this.stop();
    }

    public Server start() {
        Server oldServer = this.server.get();
        if (!ServerRuleDelegate.isStopped(oldServer)) {
            return oldServer;
        }
        ServerBuilder sb = Server.builder();
        try {
            this.configure(sb);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to configure a Server", e);
        }
        Server server = sb.build();
        server.start().join();
        this.server.set(server);
        return server;
    }

    public abstract void configure(ServerBuilder var1) throws Exception;

    public CompletableFuture<Void> stop() {
        Server server = this.server.getAndSet(null);
        if (server == null || server.activePorts().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        return server.stop();
    }

    public Server server() {
        Server server = this.server.get();
        if (ServerRuleDelegate.isStopped(server)) {
            throw new IllegalStateException("server did not start.");
        }
        return server;
    }

    private static boolean isStopped(@Nullable Server server) {
        return server == null || server.activePorts().isEmpty();
    }

    public int httpPort() {
        return this.port(SessionProtocol.HTTP);
    }

    public int httpsPort() {
        return this.port(SessionProtocol.HTTPS);
    }

    public int port(SessionProtocol protocol) {
        return this.server().activeLocalPort(protocol);
    }

    public boolean hasHttp() {
        return this.hasSessionProtocol(SessionProtocol.HTTP);
    }

    public boolean hasHttps() {
        return this.hasSessionProtocol(SessionProtocol.HTTPS);
    }

    private boolean hasSessionProtocol(SessionProtocol protocol) {
        Server server = this.server.get();
        return server != null && server.activePorts().values().stream().anyMatch(port -> port.hasProtocol(protocol));
    }

    public Endpoint endpoint(SessionProtocol protocol) {
        this.ensureStarted();
        return Endpoint.of((String)"127.0.0.1", (int)this.port(protocol));
    }

    public Endpoint httpEndpoint() {
        return this.endpoint(SessionProtocol.HTTP);
    }

    public Endpoint httpsEndpoint() {
        return this.endpoint(SessionProtocol.HTTPS);
    }

    public URI uri(SessionProtocol protocol) {
        return this.uri(protocol, SerializationFormat.NONE);
    }

    public URI uri(SessionProtocol protocol, SerializationFormat format) {
        int port;
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(format, "format");
        this.ensureStarted();
        if (!protocol.isTls() && this.hasHttp()) {
            port = this.httpPort();
        } else if (protocol.isTls() && this.hasHttps()) {
            port = this.httpsPort();
        } else {
            throw new IllegalStateException("can't find the specified port");
        }
        String uriStr = protocol.uriText() + "://127.0.0.1:" + port;
        if (format == SerializationFormat.NONE) {
            return URI.create(uriStr);
        }
        return URI.create(format.uriText() + '+' + uriStr);
    }

    public URI httpUri() {
        return this.uri(SessionProtocol.HTTP);
    }

    public URI httpUri(SerializationFormat format) {
        return this.uri(SessionProtocol.HTTP, format);
    }

    public URI httpsUri() {
        return this.uri(SessionProtocol.HTTPS);
    }

    public URI httpsUri(SerializationFormat format) {
        return this.uri(SessionProtocol.HTTPS, format);
    }

    public InetSocketAddress socketAddress(SessionProtocol protocol) {
        Objects.requireNonNull(protocol, "protocol");
        this.ensureStarted();
        return new InetSocketAddress("127.0.0.1", this.port(protocol));
    }

    public InetSocketAddress httpSocketAddress() {
        return this.socketAddress(SessionProtocol.HTTP);
    }

    public InetSocketAddress httpsSocketAddress() {
        return this.socketAddress(SessionProtocol.HTTPS);
    }

    private void ensureStarted() {
        this.server();
    }
}

