/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.testing;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.EventLoopGroups;
import io.netty.channel.EventLoopGroup;

public final class EventLoopGroupRuleDelegate {
    private final int numThreads;
    private final String threadNamePrefix;
    private final boolean useDaemonThreads;
    @Nullable
    private volatile EventLoopGroup group;

    public EventLoopGroupRuleDelegate(int numThreads, String threadNamePrefix, boolean useDaemonThreads) {
        this.numThreads = numThreads;
        this.threadNamePrefix = threadNamePrefix;
        this.useDaemonThreads = useDaemonThreads;
    }

    public EventLoopGroup group() {
        EventLoopGroup group = this.group;
        if (group == null) {
            throw new IllegalStateException(EventLoopGroup.class.getSimpleName() + " not initialized");
        }
        return group;
    }

    public void before() throws Throwable {
        this.group = EventLoopGroups.newEventLoopGroup((int)this.numThreads, (String)this.threadNamePrefix, (boolean)this.useDaemonThreads);
    }

    public void after() {
        EventLoopGroup group = this.group;
        if (group != null) {
            this.group = null;
            group.shutdownGracefully();
        }
    }
}

