/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.testing.junit5.server;

import com.linecorp.armeria.client.BlockingWebClient;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.RestClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.testing.ServerRuleDelegate;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.testing.junit5.common.AbstractAllOrEachExtension;
import com.linecorp.armeria.testing.server.ServiceRequestContextCaptor;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.junit.jupiter.api.extension.ExtensionContext;

public abstract class ServerExtension
extends AbstractAllOrEachExtension {
    private final ServiceRequestContextCaptor contextCaptor = new ServiceRequestContextCaptor();
    private final ServerRuleDelegate delegate;

    protected ServerExtension() {
        this(true);
    }

    protected ServerExtension(boolean autoStart) {
        this.delegate = new ServerRuleDelegate(autoStart){

            @Override
            public void configure(ServerBuilder sb) throws Exception {
                ServerExtension.this.configure(sb);
                sb.decorator(ServerExtension.this.contextCaptor.newDecorator(ServerExtension.this::shouldCapture));
            }

            @Override
            public void configureWebClient(WebClientBuilder wcb) throws Exception {
                ServerExtension.this.configureWebClient(wcb);
            }
        };
    }

    @Override
    public void before(ExtensionContext context) throws Exception {
        try {
            this.delegate.before();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to set up before callback", t);
        }
    }

    @Override
    public void beforeEach(ExtensionContext context) throws Exception {
        super.beforeEach(context);
        this.contextCaptor.clear();
    }

    @Override
    public void after(ExtensionContext context) throws Exception {
        this.delegate.after();
    }

    public Server start() {
        return this.delegate.start();
    }

    protected abstract void configure(ServerBuilder var1) throws Exception;

    protected void configureWebClient(WebClientBuilder webClientBuilder) throws Exception {
    }

    public CompletableFuture<Void> stop() {
        return this.delegate.stop();
    }

    public Server server() {
        return this.delegate.server();
    }

    public int httpPort() {
        return this.delegate.httpPort();
    }

    public int httpsPort() {
        return this.delegate.httpsPort();
    }

    public int port(SessionProtocol protocol) {
        return this.delegate.port(protocol);
    }

    public boolean hasHttp() {
        return this.delegate.hasHttp();
    }

    public boolean hasHttps() {
        return this.delegate.hasHttps();
    }

    public Endpoint endpoint(SessionProtocol protocol) {
        return this.delegate.endpoint(protocol);
    }

    public Endpoint httpEndpoint() {
        return this.delegate.httpEndpoint();
    }

    public Endpoint httpsEndpoint() {
        return this.delegate.httpsEndpoint();
    }

    public URI uri(SessionProtocol protocol) {
        return this.delegate.uri(protocol);
    }

    public URI uri(SessionProtocol protocol, SerializationFormat format) {
        return this.delegate.uri(protocol, format);
    }

    public URI httpUri() {
        return this.delegate.httpUri();
    }

    public URI httpUri(SerializationFormat format) {
        return this.delegate.httpUri(format);
    }

    public URI httpsUri() {
        return this.delegate.httpsUri();
    }

    public URI httpsUri(SerializationFormat format) {
        return this.delegate.httpsUri(format);
    }

    public InetSocketAddress socketAddress(SessionProtocol protocol) {
        return this.delegate.socketAddress(protocol);
    }

    public InetSocketAddress httpSocketAddress() {
        return this.delegate.httpSocketAddress();
    }

    public InetSocketAddress httpsSocketAddress() {
        return this.delegate.httpsSocketAddress();
    }

    public final ServiceRequestContextCaptor requestContextCaptor() {
        return this.contextCaptor;
    }

    public WebClient webClient() {
        return this.delegate.webClient();
    }

    public WebClient webClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        return this.delegate.webClient(webClientCustomizer);
    }

    public BlockingWebClient blockingWebClient() {
        return this.delegate.blockingWebClient();
    }

    public BlockingWebClient blockingWebClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        return this.delegate.blockingWebClient(webClientCustomizer);
    }

    public RestClient restClient() {
        return this.delegate.restClient();
    }

    public RestClient restClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        return this.delegate.restClient(webClientCustomizer);
    }

    protected boolean shouldCapture(ServiceRequestContext ctx) {
        return true;
    }
}

