/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.testing.junit5.server.mock;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.ServerBuilder;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.testing.junit5.server.ServerExtension;
import com.linecorp.armeria.testing.junit5.server.mock.RecordedRequest;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;

public class MockWebServerExtension
extends ServerExtension
implements BeforeTestExecutionCallback {
    private final BlockingQueue<HttpResponse> mockResponses = new LinkedBlockingQueue<HttpResponse>();
    private final BlockingQueue<RecordedRequest> recordedRequests = new LinkedBlockingQueue<RecordedRequest>();

    public final MockWebServerExtension enqueue(HttpResponse response) {
        Objects.requireNonNull(response, "response");
        this.mockResponses.add(response);
        return this;
    }

    public final MockWebServerExtension enqueue(AggregatedHttpResponse response) {
        Objects.requireNonNull(response, "response");
        this.mockResponses.add(response.toHttpResponse());
        return this;
    }

    @Nullable
    public final RecordedRequest takeRequest() {
        return this.takeRequest(10, TimeUnit.SECONDS);
    }

    @Nullable
    public final RecordedRequest takeRequest(int amount, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        boolean interrupted = false;
        try {
            long remainingNanos = unit.toNanos(amount);
            long end = System.nanoTime() + remainingNanos;
            while (true) {
                try {
                    RecordedRequest recordedRequest = this.recordedRequests.poll(remainingNanos, TimeUnit.NANOSECONDS);
                    return recordedRequest;
                }
                catch (InterruptedException e) {
                    interrupted = true;
                    remainingNanos = end - System.nanoTime();
                    continue;
                }
                break;
            }
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    protected final void configure(ServerBuilder sb) throws Exception {
        sb.http(0);
        sb.https(0);
        sb.tlsSelfSigned();
        sb.serviceUnder("/", (HttpService)new MockWebService());
        this.configureServer(sb);
    }

    protected void configureServer(ServerBuilder sb) throws Exception {
    }

    public final void beforeTestExecution(ExtensionContext context) {
        this.reset();
    }

    public void reset() {
        this.mockResponses.clear();
        this.recordedRequests.clear();
    }

    private class MockWebService
    implements HttpService {
        private MockWebService() {
        }

        public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
            return HttpResponse.of((CompletionStage)req.aggregate().thenApply(aggReq -> {
                MockWebServerExtension.this.recordedRequests.add(new RecordedRequest(ctx, (AggregatedHttpRequest)aggReq));
                HttpResponse response = (HttpResponse)MockWebServerExtension.this.mockResponses.poll();
                if (response == null) {
                    throw new IllegalStateException("No response enqueued. Did you call MockWebServer.enqueue? Request: " + aggReq);
                }
                return response;
            }));
        }
    }
}

