/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.testing;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.EventLoopGroups;
import io.netty.channel.EventLoopGroup;
import java.util.concurrent.ThreadFactory;

public final class EventLoopGroupRuleDelegate {
    private final int numThreads;
    private final ThreadFactory threadFactory;
    @Nullable
    private volatile EventLoopGroup group;

    public EventLoopGroupRuleDelegate(int numThreads, ThreadFactory threadFactory) {
        this.numThreads = numThreads;
        this.threadFactory = threadFactory;
    }

    public EventLoopGroup group() {
        EventLoopGroup group = this.group;
        if (group == null) {
            throw new IllegalStateException(EventLoopGroup.class.getSimpleName() + " not initialized");
        }
        return group;
    }

    public void before() throws Throwable {
        this.group = EventLoopGroups.newEventLoopGroup((int)this.numThreads, (ThreadFactory)this.threadFactory);
    }

    public void after() {
        EventLoopGroup group = this.group;
        if (group != null) {
            this.group = null;
            group.shutdownGracefully();
        }
    }
}

