/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.testing;

import com.linecorp.armeria.client.BlockingWebClient;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.RestClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.WebClientBuilder;
import com.linecorp.armeria.client.websocket.WebSocketClient;
import com.linecorp.armeria.client.websocket.WebSocketClientBuilder;
import com.linecorp.armeria.common.SerializationFormat;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.server.Server;
import com.linecorp.armeria.server.ServerBuilder;
import java.net.InetSocketAddress;
import java.net.URI;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;

public abstract class ServerRuleDelegate {
    private final AtomicReference<Server> server = new AtomicReference();
    private final boolean autoStart;
    private final AtomicReference<WebClient> webClient = new AtomicReference();
    private final AtomicReference<WebSocketClient> webSocketClient = new AtomicReference();

    protected ServerRuleDelegate(boolean autoStart) {
        this.autoStart = autoStart;
    }

    public void before() throws Throwable {
        if (this.autoStart) {
            this.start();
        }
    }

    public void after() {
        this.stop();
    }

    public Server start() {
        Server oldServer = this.server.get();
        if (!ServerRuleDelegate.isStopped(oldServer)) {
            assert (oldServer != null);
            return oldServer;
        }
        ServerBuilder sb = Server.builder();
        try {
            this.configure(sb);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to configure a Server", e);
        }
        Server server = sb.build();
        server.start().join();
        this.server.set(server);
        return server;
    }

    public abstract void configure(ServerBuilder var1) throws Exception;

    public abstract void configureWebClient(WebClientBuilder var1) throws Exception;

    @UnstableApi
    public abstract void configureWebSocketClient(WebSocketClientBuilder var1) throws Exception;

    public CompletableFuture<Void> stop() {
        Server server = this.server.getAndSet(null);
        if (server == null || server.activePorts().isEmpty()) {
            return UnmodifiableFuture.completedFuture(null);
        }
        return server.stop();
    }

    public Server server() {
        Server server = this.server.get();
        if (ServerRuleDelegate.isStopped(server)) {
            throw new IllegalStateException("server did not start.");
        }
        assert (server != null);
        return server;
    }

    private static boolean isStopped(@Nullable Server server) {
        return server == null || server.activePorts().isEmpty();
    }

    public int httpPort() {
        return this.port(SessionProtocol.HTTP);
    }

    public int httpsPort() {
        return this.port(SessionProtocol.HTTPS);
    }

    public int port(SessionProtocol protocol) {
        return this.server().activeLocalPort(protocol);
    }

    public boolean hasHttp() {
        return this.hasSessionProtocol(SessionProtocol.HTTP);
    }

    public boolean hasHttps() {
        return this.hasSessionProtocol(SessionProtocol.HTTPS);
    }

    private boolean hasSessionProtocol(SessionProtocol protocol) {
        Server server = this.server.get();
        return server != null && server.activePorts().values().stream().anyMatch(port -> port.hasProtocol(protocol));
    }

    public Endpoint endpoint(SessionProtocol protocol) {
        this.ensureStarted();
        return Endpoint.unsafeCreate((String)"127.0.0.1", (int)this.port(protocol));
    }

    public Endpoint httpEndpoint() {
        return this.endpoint(SessionProtocol.HTTP);
    }

    public Endpoint httpsEndpoint() {
        return this.endpoint(SessionProtocol.HTTPS);
    }

    public URI uri(SessionProtocol protocol) {
        return this.uri(protocol, SerializationFormat.NONE);
    }

    public URI uri(SessionProtocol protocol, SerializationFormat format) {
        int port;
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(format, "format");
        this.ensureStarted();
        if (!protocol.isTls() && this.hasHttp()) {
            port = this.httpPort();
        } else if (protocol.isTls() && this.hasHttps()) {
            port = this.httpsPort();
        } else {
            throw new IllegalStateException("can't find the specified port");
        }
        String uriStr = protocol.uriText() + "://127.0.0.1:" + port;
        if (format == SerializationFormat.NONE) {
            return URI.create(uriStr);
        }
        return URI.create(format.uriText() + '+' + uriStr);
    }

    public URI httpUri() {
        return this.uri(SessionProtocol.HTTP);
    }

    public URI httpUri(SerializationFormat format) {
        return this.uri(SessionProtocol.HTTP, format);
    }

    public URI httpsUri() {
        return this.uri(SessionProtocol.HTTPS);
    }

    public URI httpsUri(SerializationFormat format) {
        return this.uri(SessionProtocol.HTTPS, format);
    }

    public InetSocketAddress socketAddress(SessionProtocol protocol) {
        Objects.requireNonNull(protocol, "protocol");
        this.ensureStarted();
        return new InetSocketAddress("127.0.0.1", this.port(protocol));
    }

    public InetSocketAddress httpSocketAddress() {
        return this.socketAddress(SessionProtocol.HTTP);
    }

    public InetSocketAddress httpsSocketAddress() {
        return this.socketAddress(SessionProtocol.HTTPS);
    }

    public WebClient webClient() {
        WebClient webClient = this.webClient.get();
        if (webClient != null) {
            return webClient;
        }
        WebClient newWebClient = this.webClientBuilder().build();
        if (this.webClient.compareAndSet(null, newWebClient)) {
            return newWebClient;
        }
        WebClient oldWebClient = this.webClient.get();
        assert (oldWebClient != null);
        return oldWebClient;
    }

    public WebClient webClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        WebClientBuilder builder = this.webClientBuilder();
        webClientCustomizer.accept(builder);
        return builder.build();
    }

    @UnstableApi
    public BlockingWebClient blockingWebClient() {
        return this.webClient().blocking();
    }

    @UnstableApi
    public BlockingWebClient blockingWebClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        return this.webClient(webClientCustomizer).blocking();
    }

    @UnstableApi
    public RestClient restClient() {
        return this.webClient().asRestClient();
    }

    @UnstableApi
    public RestClient restClient(Consumer<WebClientBuilder> webClientCustomizer) {
        Objects.requireNonNull(webClientCustomizer, "webClientCustomizer");
        return this.webClient(webClientCustomizer).asRestClient();
    }

    @UnstableApi
    public WebSocketClient webSocketClient() {
        WebSocketClient webSocketClient = this.webSocketClient.get();
        if (webSocketClient != null) {
            return webSocketClient;
        }
        WebSocketClient newWebSocketClient = this.webSocketClientBuilder().build();
        if (this.webSocketClient.compareAndSet(null, newWebSocketClient)) {
            return newWebSocketClient;
        }
        WebSocketClient oldWebClient = this.webSocketClient.get();
        assert (oldWebClient != null);
        return oldWebClient;
    }

    private void ensureStarted() {
        this.server();
    }

    private WebClientBuilder webClientBuilder() {
        boolean hasHttps = this.hasHttps();
        WebClientBuilder webClientBuilder = WebClient.builder((URI)(hasHttps ? this.httpsUri() : this.httpUri()));
        if (hasHttps) {
            webClientBuilder.factory(ClientFactory.insecure());
        }
        try {
            this.configureWebClient(webClientBuilder);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to configure a WebClient", e);
        }
        return webClientBuilder;
    }

    private WebSocketClientBuilder webSocketClientBuilder() {
        boolean hasHttps = this.hasHttps();
        String hostAndPort = hasHttps ? "wss://" + this.httpsUri().getAuthority() : "ws://" + this.httpUri().getAuthority();
        WebSocketClientBuilder webSocketClientBuilder = WebSocketClient.builder((String)hostAndPort);
        if (hasHttps) {
            webSocketClientBuilder.factory(ClientFactory.insecure());
        }
        try {
            this.configureWebSocketClient(webSocketClientBuilder);
        }
        catch (Exception e) {
            throw new IllegalStateException("failed to configure a WebSocketClient", e);
        }
        return webSocketClientBuilder;
    }
}

