/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging.structured.kafka;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.kafka.common.serialization.Serializer;
import org.apache.kafka.common.serialization.StringSerializer;

public class StructuredLogJsonKafkaSerializer<L>
implements Serializer<L> {
    private final Serializer<String> stringSerializer = new StringSerializer();
    private final ObjectMapper objectMapper;

    public StructuredLogJsonKafkaSerializer(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void configure(Map<String, ?> map, boolean b) {
    }

    public byte[] serialize(String topic, L value) {
        if (value == null) {
            return null;
        }
        try {
            String json = this.objectMapper.writeValueAsString(value);
            return this.stringSerializer.serialize(topic, (Object)json);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public void close() {
    }
}

