/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.logging.kafka;

import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KafkaAccessLogWriter<K, V>
implements AccessLogWriter {
    private static final Logger logger = LoggerFactory.getLogger(KafkaAccessLogWriter.class);
    private final Producer<K, V> producer;
    private final String topic;
    private final Function<? super RequestLog, ? extends K> keyExtractor;
    private final Function<? super RequestLog, ? extends V> valueExtractor;

    public KafkaAccessLogWriter(Producer<K, V> producer, String topic, Function<? super RequestLog, ? extends V> valueExtractor) {
        this(producer, topic, null, valueExtractor, 0);
    }

    public KafkaAccessLogWriter(Producer<K, V> producer, String topic, Function<? super RequestLog, ? extends K> keyExtractor, Function<? super RequestLog, ? extends V> valueExtractor) {
        this(producer, topic, Objects.requireNonNull(keyExtractor, "keyExtractor"), valueExtractor, 0);
    }

    private KafkaAccessLogWriter(Producer<K, V> producer, String topic, @Nullable Function<? super RequestLog, ? extends K> keyExtractor, Function<? super RequestLog, ? extends V> valueExtractor, int dummy) {
        this.producer = Objects.requireNonNull(producer, "producer");
        this.topic = Objects.requireNonNull(topic, "topic");
        this.keyExtractor = keyExtractor == null ? log -> null : keyExtractor;
        this.valueExtractor = Objects.requireNonNull(valueExtractor, "valueExtractor");
    }

    public void log(RequestLog log) {
        V value = this.valueExtractor.apply((RequestLog)log);
        if (value == null) {
            return;
        }
        K key = this.keyExtractor.apply((RequestLog)log);
        ProducerRecord producerRecord = new ProducerRecord(this.topic, key, value);
        this.producer.send(producerRecord, (metadata, exception) -> {
            if (exception != null) {
                logger.warn("Failed to send a record to Kafka: {}", (Object)producerRecord, (Object)exception);
            }
        });
    }

    public CompletableFuture<Void> shutdown() {
        return CompletableFuture.runAsync(() -> this.producer.close());
    }
}

