/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.kotlin;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.KType;
import kotlin.reflect.jvm.KTypesJvm;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u001c\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u001a\u0014\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0002\u001a\u00020\u0003H\u0000\u00a8\u0006\u000b"}, d2={"isKFunction", "", "method", "Ljava/lang/reflect/Method;", "isReturnTypeNothing", "isReturnTypeUnit", "isSuspendingFunction", "kFunctionGenericReturnType", "Ljava/lang/reflect/Type;", "kFunctionReturnType", "Ljava/lang/Class;", "armeria-kotlin"})
@JvmName(name="ArmeriaKotlinUtil")
public final class ArmeriaKotlinUtil {
    public static final boolean isKFunction(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        return ReflectJvmMapping.getKotlinFunction((Method)method) != null;
    }

    public static final boolean isSuspendingFunction(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
        if (kFunction == null) {
            return false;
        }
        return kFunction.isSuspend();
    }

    public static final boolean isReturnTypeUnit(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
        if (kFunction == null) {
            return false;
        }
        KFunction kFunction2 = kFunction;
        return Intrinsics.areEqual((Object)KTypesJvm.getJvmErasure((KType)kFunction2.getReturnType()), (Object)Reflection.getOrCreateKotlinClass(Unit.class));
    }

    public static final boolean isReturnTypeNothing(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
        if (kFunction == null) {
            return false;
        }
        KFunction kFunction2 = kFunction;
        return Intrinsics.areEqual((Object)KTypesJvm.getJvmErasure((KType)kFunction2.getReturnType()), (Object)Reflection.getOrCreateKotlinClass(Void.class));
    }

    @NotNull
    public static final Class<?> kFunctionReturnType(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
        if (kFunction == null) {
            boolean bl = false;
            String string = "method is not a kotlin function";
            throw new IllegalArgumentException(string.toString());
        }
        return JvmClassMappingKt.getJavaClass((KClass)KTypesJvm.getJvmErasure((KType)kFunction.getReturnType()));
    }

    @NotNull
    public static final Type kFunctionGenericReturnType(@NotNull Method method) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        KFunction kFunction = ReflectJvmMapping.getKotlinFunction((Method)method);
        if (kFunction == null) {
            boolean bl = false;
            String string = "method is not a kotlin function";
            throw new IllegalArgumentException(string.toString());
        }
        return ReflectJvmMapping.getJavaType((KType)kFunction.getReturnType());
    }
}

