/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.kotlin;

import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.internal.common.kotlin.ArmeriaCoroutineUtil;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import io.netty.util.concurrent.EventExecutor;
import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.reactivestreams.Publisher;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J*\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u001f\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/linecorp/armeria/internal/common/kotlin/FlowResponseConverterFunction;", "Lcom/linecorp/armeria/server/annotation/ResponseConverterFunction;", "responseConverter", "(Lcom/linecorp/armeria/server/annotation/ResponseConverterFunction;)V", "convertResponse", "Lcom/linecorp/armeria/common/HttpResponse;", "ctx", "Lcom/linecorp/armeria/server/ServiceRequestContext;", "headers", "Lcom/linecorp/armeria/common/ResponseHeaders;", "result", "", "trailers", "Lcom/linecorp/armeria/common/HttpHeaders;", "isResponseStreaming", "", "returnType", "Ljava/lang/reflect/Type;", "produceType", "Lcom/linecorp/armeria/common/MediaType;", "(Ljava/lang/reflect/Type;Lcom/linecorp/armeria/common/MediaType;)Ljava/lang/Boolean;", "armeria-kotlin"})
public final class FlowResponseConverterFunction
implements ResponseConverterFunction {
    @NotNull
    private final ResponseConverterFunction responseConverter;

    public FlowResponseConverterFunction(@NotNull ResponseConverterFunction responseConverter) {
        Intrinsics.checkNotNullParameter((Object)responseConverter, (String)"responseConverter");
        this.responseConverter = responseConverter;
    }

    @NotNull
    public Boolean isResponseStreaming(@NotNull Type returnType, @Nullable MediaType produceType) {
        Intrinsics.checkNotNullParameter((Object)returnType, (String)"returnType");
        return true;
    }

    @NotNull
    public HttpResponse convertResponse(@NotNull ServiceRequestContext ctx, @NotNull ResponseHeaders headers, @Nullable Object result, @NotNull HttpHeaders trailers) {
        Intrinsics.checkNotNullParameter((Object)ctx, (String)"ctx");
        Intrinsics.checkNotNullParameter((Object)headers, (String)"headers");
        Intrinsics.checkNotNullParameter((Object)trailers, (String)"trailers");
        if (result instanceof Flow) {
            Flow flow = FlowKt.filterNotNull((Flow)((Flow)result));
            ContextAwareEventLoop contextAwareEventLoop = ctx.eventLoop();
            Intrinsics.checkNotNullExpressionValue((Object)contextAwareEventLoop, (String)"eventLoop(...)");
            Publisher publisher = ArmeriaCoroutineUtil.asPublisher(flow, (EventExecutor)contextAwareEventLoop, ctx);
            HttpResponse httpResponse = this.responseConverter.convertResponse(ctx, headers, publisher, trailers);
            Intrinsics.checkNotNullExpressionValue((Object)httpResponse, (String)"convertResponse(...)");
            return httpResponse;
        }
        Object object = ResponseConverterFunction.fallthrough();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fallthrough(...)");
        return (HttpResponse)object;
    }
}

