/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.logback.BuiltInProperty;
import com.linecorp.armeria.common.logback.RequestContextExporter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

final class RequestContextExporterBuilder {
    private static final String PREFIX_ATTRS = "attrs.";
    private static final String PREFIX_HTTP_REQ_HEADERS = "req.http_headers.";
    private static final String PREFIX_HTTP_RES_HEADERS = "res.http_headers.";
    private final Set<BuiltInProperty> builtIns = EnumSet.noneOf(BuiltInProperty.class);
    private final Set<RequestContextExporter.ExportEntry<AttributeKey<?>>> attrs = new HashSet();
    private final Set<RequestContextExporter.ExportEntry<AsciiString>> httpReqHeaders = new HashSet<RequestContextExporter.ExportEntry<AsciiString>>();
    private final Set<RequestContextExporter.ExportEntry<AsciiString>> httpResHeaders = new HashSet<RequestContextExporter.ExportEntry<AsciiString>>();

    RequestContextExporterBuilder() {
    }

    void addBuiltIn(BuiltInProperty property) {
        this.builtIns.add(Objects.requireNonNull(property, "property"));
    }

    boolean containsBuiltIn(BuiltInProperty property) {
        return this.builtIns.contains((Object)Objects.requireNonNull(property, "property"));
    }

    Set<BuiltInProperty> getBuiltIns() {
        return Collections.unmodifiableSet(this.builtIns);
    }

    void addAttribute(String alias, AttributeKey<?> attrKey) {
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(attrKey, "attrKey");
        this.attrs.add(new RequestContextExporter.ExportEntry(attrKey, PREFIX_ATTRS + alias, null));
    }

    void addAttribute(String alias, AttributeKey<?> attrKey, Function<?, String> stringifier) {
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(attrKey, "attrKey");
        Objects.requireNonNull(stringifier, "stringifier");
        this.attrs.add(new RequestContextExporter.ExportEntry(attrKey, PREFIX_ATTRS + alias, stringifier));
    }

    boolean containsAttribute(AttributeKey<?> key) {
        Objects.requireNonNull(key, "key");
        return this.attrs.stream().anyMatch(e -> ((AttributeKey)e.key).equals((Object)key));
    }

    Map<String, AttributeKey<?>> getAttributes() {
        return Collections.unmodifiableMap(this.attrs.stream().collect(Collectors.toMap(e -> e.mdcKey.substring(PREFIX_ATTRS.length()), e -> (AttributeKey)e.key)));
    }

    void addHttpRequestHeader(CharSequence name) {
        RequestContextExporterBuilder.addHttpHeader(PREFIX_HTTP_REQ_HEADERS, this.httpReqHeaders, name);
    }

    void addHttpResponseHeader(CharSequence name) {
        RequestContextExporterBuilder.addHttpHeader(PREFIX_HTTP_RES_HEADERS, this.httpResHeaders, name);
    }

    private static void addHttpHeader(String mdcKeyPrefix, Set<RequestContextExporter.ExportEntry<AsciiString>> httpHeaders, CharSequence name) {
        AsciiString key = RequestContextExporterBuilder.toHeaderName(name);
        String value = mdcKeyPrefix + key;
        httpHeaders.add(new RequestContextExporter.ExportEntry<AsciiString>(key, value, null));
    }

    boolean containsHttpRequestHeader(CharSequence name) {
        return this.httpReqHeaders.stream().anyMatch(e -> ((AsciiString)e.key).contentEqualsIgnoreCase(name));
    }

    boolean containsHttpResponseHeader(CharSequence name) {
        return this.httpResHeaders.stream().anyMatch(e -> ((AsciiString)e.key).contentEqualsIgnoreCase(name));
    }

    private static AsciiString toHeaderName(CharSequence name) {
        return HttpHeaderNames.of((CharSequence)Objects.requireNonNull(name, "name").toString());
    }

    Set<AsciiString> getHttpRequestHeaders() {
        return (Set)this.httpReqHeaders.stream().map(e -> (AsciiString)e.key).collect(ImmutableSet.toImmutableSet());
    }

    Set<AsciiString> getHttpResponseHeaders() {
        return (Set)this.httpResHeaders.stream().map(e -> (AsciiString)e.key).collect(ImmutableSet.toImmutableSet());
    }

    void export(String mdcKey) {
        Objects.requireNonNull(mdcKey, "mdcKey");
        Optional<BuiltInProperty> opt = BuiltInProperty.findByMdcKey(mdcKey);
        if (opt.isPresent()) {
            this.builtIns.add(opt.get());
            return;
        }
        if (mdcKey.startsWith(PREFIX_ATTRS)) {
            String[] components = mdcKey.split(":");
            switch (components.length) {
                case 2: {
                    this.addAttribute(components[0].substring(PREFIX_ATTRS.length()), AttributeKey.valueOf((String)components[1]));
                    break;
                }
                case 3: {
                    Function<?, String> stringifier = this.newStringifier(mdcKey, components[2]);
                    this.addAttribute(components[0].substring(PREFIX_ATTRS.length()), AttributeKey.valueOf((String)components[1]), stringifier);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("invalid attribute export: " + mdcKey + " (expected: attrs.<alias>:<AttributeKey.name>[:<FQCN of Function<?, String>>])");
                }
            }
            return;
        }
        if (mdcKey.startsWith(PREFIX_HTTP_REQ_HEADERS)) {
            this.addHttpRequestHeader(mdcKey.substring(PREFIX_HTTP_REQ_HEADERS.length()));
            return;
        }
        if (mdcKey.startsWith(PREFIX_HTTP_RES_HEADERS)) {
            this.addHttpResponseHeader(mdcKey.substring(PREFIX_HTTP_RES_HEADERS.length()));
            return;
        }
        throw new IllegalArgumentException("unknown MDC key: " + mdcKey);
    }

    private Function<?, String> newStringifier(String mdcKey, String className) {
        Function stringifier;
        try {
            stringifier = (Function)Class.forName(className, true, this.getClass().getClassLoader()).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("failed to instantiate a stringifier function: " + mdcKey, e);
        }
        return stringifier;
    }

    RequestContextExporter build() {
        return new RequestContextExporter(this.builtIns, this.attrs, this.httpReqHeaders, this.httpResHeaders);
    }
}

