/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.RpcResponse;
import com.linecorp.armeria.common.logback.BuiltInProperties;
import com.linecorp.armeria.common.logback.BuiltInProperty;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.shaded.guava.io.BaseEncoding;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.util.AsciiString;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSession;

final class RequestContextExporter {
    private static final Pattern PORT_443 = Pattern.compile(":0*443$");
    private static final Pattern PORT_80 = Pattern.compile(":0*80$");
    private static final BaseEncoding lowerCasedBase16 = BaseEncoding.base16().lowerCase();
    private static final ExportEntry[] EMPTY_EXPORT_ENTRIES = new ExportEntry[0];
    private final BuiltInProperties builtIns = new BuiltInProperties();
    @Nullable
    private final ExportEntry<AttributeKey<?>>[] attrs;
    @Nullable
    private final ExportEntry<AsciiString>[] httpReqHeaders;
    @Nullable
    private final ExportEntry<AsciiString>[] httpResHeaders;

    RequestContextExporter(Set<BuiltInProperty> builtIns, Set<ExportEntry<AttributeKey<?>>> attrs, Set<ExportEntry<AsciiString>> httpReqHeaders, Set<ExportEntry<AsciiString>> httpResHeaders) {
        builtIns.forEach(this.builtIns::add);
        this.attrs = !attrs.isEmpty() ? attrs.toArray(EMPTY_EXPORT_ENTRIES) : null;
        this.httpReqHeaders = !httpReqHeaders.isEmpty() ? httpReqHeaders.toArray(EMPTY_EXPORT_ENTRIES) : null;
        this.httpResHeaders = !httpResHeaders.isEmpty() ? httpResHeaders.toArray(EMPTY_EXPORT_ENTRIES) : null;
    }

    void export(Map<String, String> out, RequestContext ctx, RequestLog log) {
        if (this.builtIns.containsAddresses()) {
            this.exportAddresses(out, ctx);
        }
        if (this.builtIns.contains(BuiltInProperty.SCHEME)) {
            RequestContextExporter.exportScheme(out, ctx, log);
        }
        if (this.builtIns.contains(BuiltInProperty.REQ_DIRECTION)) {
            RequestContextExporter.exportDirection(out, ctx);
        }
        if (this.builtIns.contains(BuiltInProperty.REQ_AUTHORITY)) {
            RequestContextExporter.exportAuthority(out, ctx, log);
        }
        if (this.builtIns.contains(BuiltInProperty.REQ_PATH)) {
            RequestContextExporter.exportPath(out, ctx);
        }
        if (this.builtIns.contains(BuiltInProperty.REQ_QUERY)) {
            RequestContextExporter.exportQuery(out, ctx);
        }
        if (this.builtIns.contains(BuiltInProperty.REQ_METHOD)) {
            RequestContextExporter.exportMethod(out, ctx);
        }
        if (this.builtIns.contains(BuiltInProperty.REQ_CONTENT_LENGTH)) {
            RequestContextExporter.exportRequestContentLength(out, log);
        }
        if (this.builtIns.contains(BuiltInProperty.RES_STATUS_CODE)) {
            RequestContextExporter.exportStatusCode(out, log);
        }
        if (this.builtIns.contains(BuiltInProperty.RES_CONTENT_LENGTH)) {
            RequestContextExporter.exportResponseContentLength(out, log);
        }
        if (this.builtIns.contains(BuiltInProperty.ELAPSED_NANOS)) {
            RequestContextExporter.exportElapsedNanos(out, log);
        }
        if (this.builtIns.containsSsl()) {
            this.exportTlsProperties(out, ctx);
        }
        if (this.builtIns.containsRpc()) {
            this.exportRpcRequest(out, log);
            this.exportRpcResponse(out, log);
        }
        this.exportAttributes(out, ctx);
        this.exportHttpRequestHeaders(out, log);
        this.exportHttpResponseHeaders(out, log);
    }

    private void exportAddresses(Map<String, String> out, RequestContext ctx) {
        InetAddress caddr;
        InetSocketAddress raddr = (InetSocketAddress)ctx.remoteAddress();
        InetSocketAddress laddr = (InetSocketAddress)ctx.localAddress();
        InetAddress inetAddress = caddr = ctx instanceof ServiceRequestContext ? ((ServiceRequestContext)ctx).clientAddress() : null;
        if (raddr != null) {
            if (this.builtIns.contains(BuiltInProperty.REMOTE_HOST)) {
                out.put(BuiltInProperty.REMOTE_HOST.mdcKey, raddr.getHostString());
            }
            if (this.builtIns.contains(BuiltInProperty.REMOTE_IP)) {
                out.put(BuiltInProperty.REMOTE_IP.mdcKey, raddr.getAddress().getHostAddress());
            }
            if (this.builtIns.contains(BuiltInProperty.REMOTE_PORT)) {
                out.put(BuiltInProperty.REMOTE_PORT.mdcKey, String.valueOf(raddr.getPort()));
            }
        }
        if (laddr != null) {
            if (this.builtIns.contains(BuiltInProperty.LOCAL_HOST)) {
                out.put(BuiltInProperty.LOCAL_HOST.mdcKey, laddr.getHostString());
            }
            if (this.builtIns.contains(BuiltInProperty.LOCAL_IP)) {
                out.put(BuiltInProperty.LOCAL_IP.mdcKey, laddr.getAddress().getHostAddress());
            }
            if (this.builtIns.contains(BuiltInProperty.LOCAL_PORT)) {
                out.put(BuiltInProperty.LOCAL_PORT.mdcKey, String.valueOf(laddr.getPort()));
            }
        }
        if (caddr != null && this.builtIns.contains(BuiltInProperty.CLIENT_IP)) {
            out.put(BuiltInProperty.CLIENT_IP.mdcKey, caddr.getHostAddress());
        }
    }

    private static void exportScheme(Map<String, String> out, RequestContext ctx, RequestLog log) {
        if (log.isAvailable(RequestLogAvailability.SCHEME)) {
            out.put(BuiltInProperty.SCHEME.mdcKey, log.scheme().uriText());
        } else {
            out.put(BuiltInProperty.SCHEME.mdcKey, "unknown+" + ctx.sessionProtocol().uriText());
        }
    }

    private static void exportDirection(Map<String, String> out, RequestContext ctx) {
        String d = ctx instanceof ServiceRequestContext ? "INBOUND" : (ctx instanceof ClientRequestContext ? "OUTBOUND" : "UNKNOWN");
        out.put(BuiltInProperty.REQ_DIRECTION.mdcKey, d);
    }

    private static void exportAuthority(Map<String, String> out, RequestContext ctx, RequestLog log) {
        String authority;
        String authority2;
        Set availabilities = log.availabilities();
        if (availabilities.contains(RequestLogAvailability.REQUEST_HEADERS) && (authority2 = RequestContextExporter.getAuthority(ctx, (HttpHeaders)log.requestHeaders())) != null) {
            out.put(BuiltInProperty.REQ_AUTHORITY.mdcKey, authority2);
            return;
        }
        Request origReq = ctx.request();
        if (origReq instanceof HttpRequest && (authority = RequestContextExporter.getAuthority(ctx, (HttpHeaders)((HttpRequest)origReq).headers())) != null) {
            out.put(BuiltInProperty.REQ_AUTHORITY.mdcKey, authority);
            return;
        }
        if (log.isAvailable(RequestLogAvailability.REQUEST_START) && !"?".equals(authority = log.authority())) {
            out.put(BuiltInProperty.REQ_AUTHORITY.mdcKey, authority);
            return;
        }
        if (ctx instanceof ServiceRequestContext) {
            ServiceRequestContext sCtx = (ServiceRequestContext)ctx;
            int port = ((InetSocketAddress)sCtx.remoteAddress()).getPort();
            String hostname = sCtx.virtualHost().defaultHostname();
            authority = port == ctx.sessionProtocol().defaultPort() ? hostname : hostname + ':' + port;
        } else {
            int defaultPort;
            int port;
            ClientRequestContext cCtx = (ClientRequestContext)ctx;
            Endpoint endpoint = cCtx.endpoint();
            authority = endpoint.isGroup() ? endpoint.authority() : ((port = endpoint.port(defaultPort = cCtx.sessionProtocol().defaultPort())) == defaultPort ? endpoint.host() : endpoint.host() + ':' + port);
        }
        out.put(BuiltInProperty.REQ_AUTHORITY.mdcKey, authority);
    }

    @Nullable
    private static String getAuthority(RequestContext ctx, HttpHeaders headers) {
        String authority = headers.get((CharSequence)HttpHeaderNames.AUTHORITY);
        if (authority != null) {
            Pattern portPattern = ctx.sessionProtocol().isTls() ? PORT_443 : PORT_80;
            Matcher m = portPattern.matcher(authority);
            if (m.find()) {
                authority = authority.substring(0, m.start());
            }
            return authority;
        }
        return null;
    }

    private static void exportPath(Map<String, String> out, RequestContext ctx) {
        out.put(BuiltInProperty.REQ_PATH.mdcKey, ctx.path());
    }

    private static void exportQuery(Map<String, String> out, RequestContext ctx) {
        out.put(BuiltInProperty.REQ_QUERY.mdcKey, ctx.query());
    }

    private static void exportMethod(Map<String, String> out, RequestContext ctx) {
        out.put(BuiltInProperty.REQ_METHOD.mdcKey, ctx.method().name());
    }

    private static void exportRequestContentLength(Map<String, String> out, RequestLog log) {
        if (log.isAvailable(RequestLogAvailability.REQUEST_END)) {
            out.put(BuiltInProperty.REQ_CONTENT_LENGTH.mdcKey, String.valueOf(log.requestLength()));
        }
    }

    private static void exportStatusCode(Map<String, String> out, RequestLog log) {
        if (log.isAvailable(RequestLogAvailability.RESPONSE_HEADERS)) {
            out.put(BuiltInProperty.RES_STATUS_CODE.mdcKey, log.status().codeAsText());
        }
    }

    private static void exportResponseContentLength(Map<String, String> out, RequestLog log) {
        if (log.isAvailable(RequestLogAvailability.RESPONSE_END)) {
            out.put(BuiltInProperty.RES_CONTENT_LENGTH.mdcKey, String.valueOf(log.responseLength()));
        }
    }

    private static void exportElapsedNanos(Map<String, String> out, RequestLog log) {
        if (log.isAvailable(RequestLogAvailability.COMPLETE)) {
            out.put(BuiltInProperty.ELAPSED_NANOS.mdcKey, String.valueOf(log.totalDurationNanos()));
        }
    }

    private void exportTlsProperties(Map<String, String> out, RequestContext ctx) {
        SSLSession s = ctx.sslSession();
        if (s != null) {
            String p;
            String cs;
            byte[] id;
            if (this.builtIns.contains(BuiltInProperty.TLS_SESSION_ID) && (id = s.getId()) != null) {
                out.put(BuiltInProperty.TLS_SESSION_ID.mdcKey, lowerCasedBase16.encode(id));
            }
            if (this.builtIns.contains(BuiltInProperty.TLS_CIPHER) && (cs = s.getCipherSuite()) != null) {
                out.put(BuiltInProperty.TLS_CIPHER.mdcKey, cs);
            }
            if (this.builtIns.contains(BuiltInProperty.TLS_PROTO) && (p = s.getProtocol()) != null) {
                out.put(BuiltInProperty.TLS_PROTO.mdcKey, p);
            }
        }
    }

    private void exportRpcRequest(Map<String, String> out, RequestLog log) {
        if (!log.isAvailable(RequestLogAvailability.REQUEST_CONTENT)) {
            return;
        }
        Object requestContent = log.requestContent();
        if (requestContent instanceof RpcRequest) {
            RpcRequest rpcReq = (RpcRequest)requestContent;
            if (this.builtIns.contains(BuiltInProperty.REQ_RPC_METHOD)) {
                out.put(BuiltInProperty.REQ_RPC_METHOD.mdcKey, rpcReq.method());
            }
            if (this.builtIns.contains(BuiltInProperty.REQ_RPC_PARAMS)) {
                out.put(BuiltInProperty.REQ_RPC_PARAMS.mdcKey, String.valueOf(rpcReq.params()));
            }
        }
    }

    private void exportRpcResponse(Map<String, String> out, RequestLog log) {
        if (!log.isAvailable(RequestLogAvailability.RESPONSE_CONTENT)) {
            return;
        }
        Object responseContent = log.responseContent();
        if (responseContent instanceof RpcResponse) {
            RpcResponse rpcRes = (RpcResponse)responseContent;
            if (this.builtIns.contains(BuiltInProperty.RES_RPC_RESULT) && !rpcRes.isCompletedExceptionally()) {
                try {
                    out.put(BuiltInProperty.RES_RPC_RESULT.mdcKey, String.valueOf(rpcRes.get()));
                }
                catch (Exception e) {
                    throw new Error(e);
                }
            }
        }
    }

    private void exportAttributes(Map<String, String> out, RequestContext ctx) {
        if (this.attrs == null) {
            return;
        }
        for (ExportEntry<AttributeKey<?>> e : this.attrs) {
            Object value;
            AttributeKey attrKey = (AttributeKey)e.key;
            String mdcKey = e.mdcKey;
            if (!ctx.hasAttr(attrKey) || (value = ctx.attr(attrKey).get()) == null) continue;
            out.put(mdcKey, e.stringify(value));
        }
    }

    private void exportHttpRequestHeaders(Map<String, String> out, RequestLog log) {
        if (this.httpReqHeaders == null || !log.isAvailable(RequestLogAvailability.REQUEST_HEADERS)) {
            return;
        }
        RequestContextExporter.exportHttpHeaders(out, (HttpHeaders)log.requestHeaders(), this.httpReqHeaders);
    }

    private void exportHttpResponseHeaders(Map<String, String> out, RequestLog log) {
        if (this.httpResHeaders == null || !log.isAvailable(RequestLogAvailability.RESPONSE_HEADERS)) {
            return;
        }
        RequestContextExporter.exportHttpHeaders(out, (HttpHeaders)log.responseHeaders(), this.httpResHeaders);
    }

    private static void exportHttpHeaders(Map<String, String> out, HttpHeaders headers, ExportEntry<AsciiString>[] requiredHeaderNames) {
        for (ExportEntry<AsciiString> e : requiredHeaderNames) {
            String value = headers.get((CharSequence)e.key);
            String mdcKey = e.mdcKey;
            if (value == null) continue;
            out.put(mdcKey, e.stringify(value));
        }
    }

    static final class ExportEntry<T> {
        final T key;
        final String mdcKey;
        @Nullable
        final Function<Object, String> stringifier;

        ExportEntry(T key, String mdcKey, @Nullable Function<?, ?> stringifier) {
            assert (key != null);
            assert (mdcKey != null);
            this.key = key;
            this.mdcKey = mdcKey;
            this.stringifier = stringifier;
        }

        @Nullable
        String stringify(@Nullable Object value) {
            if (this.stringifier == null) {
                return value != null ? value.toString() : null;
            }
            return this.stringifier.apply(value);
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ExportEntry)) {
                return false;
            }
            return this.key.equals(((ExportEntry)o).key);
        }

        public String toString() {
            return this.mdcKey + ':' + this.key;
        }
    }
}

