/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.logback.BuiltInProperty;
import com.linecorp.armeria.common.logback.RequestContextExporter;
import com.linecorp.armeria.common.logback.RequestContextExporterBuilder;
import com.linecorp.armeria.common.logback.UnionMap;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAvailability;
import com.linecorp.armeria.internal.shaded.fastutil.objects.Object2ObjectOpenHashMap;
import io.netty.util.AsciiString;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Marker;

public class RequestContextExportingAppender
extends UnsynchronizedAppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private static final AttributeKey<State> STATE;
    @Nullable
    private RequestContextExporter exporter;
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();
    private final RequestContextExporterBuilder builder = new RequestContextExporterBuilder();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void addBuiltIn(BuiltInProperty property) {
        this.ensureNotStarted();
        this.builder.addBuiltIn(property);
    }

    public boolean containsBuiltIn(BuiltInProperty property) {
        return this.builder.containsBuiltIn(property);
    }

    public Set<BuiltInProperty> getBuiltIns() {
        return this.builder.getBuiltIns();
    }

    public void addAttribute(String alias, AttributeKey<?> attrKey) {
        this.ensureNotStarted();
        this.builder.addAttribute(alias, attrKey);
    }

    public void addAttribute(String alias, AttributeKey<?> attrKey, Function<?, String> stringifier) {
        this.ensureNotStarted();
        this.builder.addAttribute(alias, attrKey, stringifier);
    }

    public boolean containsAttribute(AttributeKey<?> key) {
        Objects.requireNonNull(key, "key");
        return this.builder.containsAttribute(key);
    }

    public Map<String, AttributeKey<?>> getAttributes() {
        return this.builder.getAttributes();
    }

    public void addHttpRequestHeader(CharSequence name) {
        this.ensureNotStarted();
        this.builder.addHttpRequestHeader(name);
    }

    public void addHttpResponseHeader(CharSequence name) {
        this.ensureNotStarted();
        this.builder.addHttpResponseHeader(name);
    }

    public boolean containsHttpRequestHeader(CharSequence name) {
        return this.builder.containsHttpRequestHeader(name);
    }

    public boolean containsHttpResponseHeader(CharSequence name) {
        return this.builder.containsHttpResponseHeader(name);
    }

    public Set<AsciiString> getHttpRequestHeaders() {
        return this.builder.getHttpRequestHeaders();
    }

    public Set<AsciiString> getHttpResponseHeaders() {
        return this.builder.getHttpResponseHeaders();
    }

    public void setExport(String mdcKey) {
        this.ensureNotStarted();
        this.builder.export(mdcKey);
    }

    public void setExports(String mdcKeys) {
        this.ensureNotStarted();
        Objects.requireNonNull(mdcKeys, "mdcKeys");
        Arrays.stream(mdcKeys.split(",")).map(String::trim).forEach(this::setExport);
    }

    private void ensureNotStarted() {
        if (this.exporter != null) {
            throw new IllegalStateException("can't update the export list once started");
        }
    }

    protected void append(ILoggingEvent eventObject) {
        RequestContext ctx = (RequestContext)RequestContext.mapCurrent(Function.identity(), () -> null);
        if (ctx != null) {
            Map originalMdcMap;
            State state = RequestContextExportingAppender.state(ctx);
            RequestLog log = ctx.log();
            Set availabilities = log.availabilities();
            if (!availabilities.equals(state.availabilities)) {
                state.availabilities = availabilities;
                this.export((Map<String, String>)((Object)state), ctx, log);
            }
            Object mdcMap = !(originalMdcMap = eventObject.getMDCPropertyMap()).isEmpty() ? new UnionMap(state.clone(), originalMdcMap) : state.clone();
            eventObject = new LoggingEventWrapper(eventObject, (Map<String, String>)mdcMap);
        }
        this.aai.appendLoopOnAppenders((Object)eventObject);
    }

    private static State state(RequestContext ctx) {
        Attribute attr = ctx.attr(STATE);
        State state = (State)((Object)attr.get());
        if (state == null) {
            State newState = new State();
            State oldState = (State)((Object)attr.setIfAbsent((Object)newState));
            if (oldState != null) {
                return oldState;
            }
            return newState;
        }
        return state;
    }

    protected void export(Map<String, String> out, RequestContext ctx, RequestLog log) {
        if (!$assertionsDisabled && this.exporter == null) {
            throw new AssertionError();
        }
        this.exporter.export(out, ctx, log);
    }

    public void start() {
        if (!this.aai.iteratorForAppenders().hasNext()) {
            this.addWarn("No appender was attached to " + ((Object)((Object)this)).getClass().getSimpleName() + '.');
        }
        if (this.exporter == null) {
            this.exporter = this.builder.build();
        }
        super.start();
    }

    public void stop() {
        try {
            this.aai.detachAndStopAllAppenders();
        }
        finally {
            super.stop();
        }
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    static {
        boolean bl = $assertionsDisabled = !RequestContextExportingAppender.class.desiredAssertionStatus();
        if (InternalLoggerFactory.getDefaultFactory() == null) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        }
        STATE = AttributeKey.valueOf(RequestContextExportingAppender.class, (String)"STATE");
    }

    private static final class LoggingEventWrapper
    implements ILoggingEvent {
        private final ILoggingEvent event;
        private final Map<String, String> mdcPropertyMap;
        @Nullable
        private final LoggerContextVO vo;

        LoggingEventWrapper(ILoggingEvent event, Map<String, String> mdcPropertyMap) {
            this.event = event;
            this.mdcPropertyMap = mdcPropertyMap;
            LoggerContextVO oldVo = event.getLoggerContextVO();
            this.vo = oldVo != null ? new LoggerContextVO(oldVo.getName(), mdcPropertyMap, oldVo.getBirthTime()) : null;
        }

        public Object[] getArgumentArray() {
            return this.event.getArgumentArray();
        }

        public Level getLevel() {
            return this.event.getLevel();
        }

        public String getLoggerName() {
            return this.event.getLoggerName();
        }

        public String getThreadName() {
            return this.event.getThreadName();
        }

        public IThrowableProxy getThrowableProxy() {
            return this.event.getThrowableProxy();
        }

        public void prepareForDeferredProcessing() {
            this.event.prepareForDeferredProcessing();
        }

        @Nullable
        public LoggerContextVO getLoggerContextVO() {
            return this.vo;
        }

        public String getMessage() {
            return this.event.getMessage();
        }

        public long getTimeStamp() {
            return this.event.getTimeStamp();
        }

        public StackTraceElement[] getCallerData() {
            return this.event.getCallerData();
        }

        public boolean hasCallerData() {
            return this.event.hasCallerData();
        }

        public Marker getMarker() {
            return this.event.getMarker();
        }

        public String getFormattedMessage() {
            return this.event.getFormattedMessage();
        }

        public Map<String, String> getMDCPropertyMap() {
            return this.mdcPropertyMap;
        }

        @Deprecated
        public Map<String, String> getMdc() {
            return this.event.getMDCPropertyMap();
        }

        public String toString() {
            return this.event.toString();
        }
    }

    private static final class State
    extends Object2ObjectOpenHashMap<String, String> {
        private static final long serialVersionUID = -7084248226635055988L;
        @Nullable
        Set<RequestLogAvailability> availabilities;

        private State() {
        }
    }
}

