/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import java.util.AbstractMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

final class UnionMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> first;
    private final Map<K, V> second;
    private int size = -1;
    @Nullable
    private Set<Map.Entry<K, V>> entrySet;

    UnionMap(Map<K, V> first, Map<K, V> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public int size() {
        Map<K, V> b;
        Map<K, V> a;
        if (this.size >= 0) {
            return this.size;
        }
        if (this.first.size() >= this.second.size()) {
            a = this.first;
            b = this.second;
        } else {
            a = this.second;
            b = this.first;
        }
        int size = a.size();
        if (!b.isEmpty()) {
            for (K k : b.keySet()) {
                if (a.containsKey(k)) continue;
                ++size;
            }
        }
        this.size = size;
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.first.isEmpty() && this.second.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.first.containsKey(key) || this.second.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.first.containsValue(value) || this.second.containsValue(value);
    }

    @Override
    public V get(Object key) {
        V value = this.first.get(key);
        return value != null ? value : this.second.get(key);
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet != null) {
            return this.entrySet;
        }
        this.entrySet = Collections.unmodifiableSet(Sets.union(this.first.entrySet(), this.second.entrySet()));
        return this.entrySet;
    }
}

