/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.spi.IThrowableProxy;
import ch.qos.logback.classic.spi.LoggerContextVO;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import ch.qos.logback.core.spi.AppenderAttachable;
import ch.qos.logback.core.spi.AppenderAttachableImpl;
import com.linecorp.armeria.common.logback.ExportGroupConfig;
import com.linecorp.armeria.common.logback.UnionMap;
import com.linecorp.armeria.common.logging.BuiltInProperty;
import com.linecorp.armeria.common.logging.RequestContextExporter;
import com.linecorp.armeria.common.logging.RequestContextExporterBuilder;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import io.netty.util.AttributeKey;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.netty.util.internal.logging.Slf4JLoggerFactory;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.slf4j.Marker;

public final class RequestContextExportingAppender
extends UnsynchronizedAppenderBase<ILoggingEvent>
implements AppenderAttachable<ILoggingEvent> {
    private static final Splitter KEY_SPLITTER;
    private final AppenderAttachableImpl<ILoggingEvent> aai = new AppenderAttachableImpl();
    private final RequestContextExporterBuilder builder = RequestContextExporter.builder();
    @Nullable
    private RequestContextExporter exporter;

    @VisibleForTesting
    RequestContextExporter exporter() {
        Preconditions.checkState((this.exporter != null ? 1 : 0) != 0);
        return this.exporter;
    }

    public void addBuiltIn(BuiltInProperty property) {
        this.ensureNotStarted();
        this.builder.builtIn(property);
    }

    public void addAttribute(String alias, AttributeKey<?> attrKey) {
        this.ensureNotStarted();
        this.builder.attr(alias, attrKey);
    }

    public void addAttribute(String alias, AttributeKey<?> attrKey, Function<?, String> stringifier) {
        this.ensureNotStarted();
        Objects.requireNonNull(alias, "alias");
        Objects.requireNonNull(attrKey, "attrKey");
        Objects.requireNonNull(stringifier, "stringifier");
        this.builder.attr(alias, attrKey, stringifier);
    }

    public void addRequestHeader(CharSequence name) {
        this.ensureNotStarted();
        Objects.requireNonNull(name, "name");
        this.builder.requestHeader(name);
    }

    public void addResponseHeader(CharSequence name) {
        this.ensureNotStarted();
        Objects.requireNonNull(name, "name");
        this.builder.responseHeader(name);
    }

    public void setPrefix(String prefix) {
        Objects.requireNonNull(prefix, "prefix");
        Preconditions.checkArgument((!prefix.isEmpty() ? 1 : 0) != 0, (Object)"prefix must not be empty");
        this.builder.prefix(prefix);
    }

    public void setExport(String mdcKey) {
        Objects.requireNonNull(mdcKey, "mdcKey");
        Preconditions.checkArgument((!mdcKey.isEmpty() ? 1 : 0) != 0, (Object)"mdcKey must not be empty");
        this.builder.keyPattern(mdcKey);
    }

    public void setExports(String mdcKeys) {
        Objects.requireNonNull(mdcKeys, "mdcKeys");
        Preconditions.checkArgument((!mdcKeys.isEmpty() ? 1 : 0) != 0, (Object)"mdcKeys must not be empty");
        KEY_SPLITTER.split((CharSequence)mdcKeys).forEach(mdcKey -> {
            Preconditions.checkArgument((!mdcKey.isEmpty() ? 1 : 0) != 0, (Object)"comma-separated MDC key must not be empty");
            this.builder.keyPattern(mdcKey);
        });
    }

    public void setExportGroup(ExportGroupConfig exportGroupConfiguration) {
        Objects.requireNonNull(exportGroupConfiguration, "exportGroupConfiguration");
        this.builder.exportGroup(exportGroupConfiguration.build());
    }

    private void ensureNotStarted() {
        if (this.isStarted()) {
            throw new IllegalStateException("can't update the export list once started");
        }
    }

    protected void append(ILoggingEvent eventObject) {
        UnionMap<String, String> contextMap;
        if (this.exporter == null) {
            this.exporter = this.builder.build();
        }
        if (!(contextMap = this.exporter.export()).isEmpty()) {
            Map originalMdcMap = eventObject.getMDCPropertyMap();
            UnionMap<String, String> mdcMap = !originalMdcMap.isEmpty() ? new UnionMap<String, String>(contextMap, originalMdcMap) : contextMap;
            eventObject = new LoggingEventWrapper(eventObject, mdcMap);
        }
        this.aai.appendLoopOnAppenders((Object)eventObject);
    }

    public void start() {
        if (!this.aai.iteratorForAppenders().hasNext()) {
            this.addWarn("No appender was attached to " + ((Object)((Object)this)).getClass().getSimpleName() + '.');
        }
        super.start();
    }

    public void stop() {
        try {
            this.aai.detachAndStopAllAppenders();
        }
        finally {
            super.stop();
        }
    }

    public void addAppender(Appender<ILoggingEvent> newAppender) {
        this.aai.addAppender(newAppender);
    }

    public Iterator<Appender<ILoggingEvent>> iteratorForAppenders() {
        return this.aai.iteratorForAppenders();
    }

    public Appender<ILoggingEvent> getAppender(String name) {
        return this.aai.getAppender(name);
    }

    public boolean isAttached(Appender<ILoggingEvent> appender) {
        return this.aai.isAttached(appender);
    }

    public void detachAndStopAllAppenders() {
        this.aai.detachAndStopAllAppenders();
    }

    public boolean detachAppender(Appender<ILoggingEvent> appender) {
        return this.aai.detachAppender(appender);
    }

    public boolean detachAppender(String name) {
        return this.aai.detachAppender(name);
    }

    static {
        if (InternalLoggerFactory.getDefaultFactory() == null) {
            InternalLoggerFactory.setDefaultFactory((InternalLoggerFactory)Slf4JLoggerFactory.INSTANCE);
        }
        KEY_SPLITTER = Splitter.on((char)',').trimResults();
    }

    private static final class LoggingEventWrapper
    implements ILoggingEvent {
        private final ILoggingEvent event;
        private final Map<String, String> mdcPropertyMap;
        @Nullable
        private final LoggerContextVO vo;

        LoggingEventWrapper(ILoggingEvent event, Map<String, String> mdcPropertyMap) {
            this.event = event;
            this.mdcPropertyMap = mdcPropertyMap;
            LoggerContextVO oldVo = event.getLoggerContextVO();
            this.vo = oldVo != null ? new LoggerContextVO(oldVo.getName(), mdcPropertyMap, oldVo.getBirthTime()) : null;
        }

        public Object[] getArgumentArray() {
            return this.event.getArgumentArray();
        }

        public Level getLevel() {
            return this.event.getLevel();
        }

        public String getLoggerName() {
            return this.event.getLoggerName();
        }

        public String getThreadName() {
            return this.event.getThreadName();
        }

        public IThrowableProxy getThrowableProxy() {
            return this.event.getThrowableProxy();
        }

        public void prepareForDeferredProcessing() {
            this.event.prepareForDeferredProcessing();
        }

        @Nullable
        public LoggerContextVO getLoggerContextVO() {
            return this.vo;
        }

        public String getMessage() {
            return this.event.getMessage();
        }

        public long getTimeStamp() {
            return this.event.getTimeStamp();
        }

        public StackTraceElement[] getCallerData() {
            return this.event.getCallerData();
        }

        public boolean hasCallerData() {
            return this.event.hasCallerData();
        }

        public Marker getMarker() {
            return this.event.getMarker();
        }

        public String getFormattedMessage() {
            return this.event.getFormattedMessage();
        }

        public Map<String, String> getMDCPropertyMap() {
            return this.mdcPropertyMap;
        }

        @Deprecated
        public Map<String, String> getMdc() {
            return this.event.getMDCPropertyMap();
        }

        public String toString() {
            return this.event.toString();
        }
    }
}

