/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.protobuf;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.EnumValueInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldInfoBuilder;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfoProvider;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import com.linecorp.armeria.server.protobuf.ProtobufRequestConverterFunction;
import com.linecorp.armeria.server.protobuf.ProtobufRequestConverterFunctionProvider;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public final class ProtobufNamedTypeInfoProvider
implements NamedTypeInfoProvider {
    @VisibleForTesting
    static final TypeSignature BOOL = TypeSignature.ofBase((String)"bool");
    @VisibleForTesting
    static final TypeSignature INT32 = TypeSignature.ofBase((String)"int32");
    @VisibleForTesting
    static final TypeSignature INT64 = TypeSignature.ofBase((String)"int64");
    @VisibleForTesting
    static final TypeSignature UINT32 = TypeSignature.ofBase((String)"uint32");
    @VisibleForTesting
    static final TypeSignature UINT64 = TypeSignature.ofBase((String)"uint64");
    @VisibleForTesting
    static final TypeSignature SINT32 = TypeSignature.ofBase((String)"sint32");
    @VisibleForTesting
    static final TypeSignature SINT64 = TypeSignature.ofBase((String)"sint64");
    @VisibleForTesting
    static final TypeSignature FLOAT = TypeSignature.ofBase((String)"float");
    @VisibleForTesting
    static final TypeSignature DOUBLE = TypeSignature.ofBase((String)"double");
    @VisibleForTesting
    static final TypeSignature FIXED32 = TypeSignature.ofBase((String)"fixed32");
    @VisibleForTesting
    static final TypeSignature FIXED64 = TypeSignature.ofBase((String)"fixed64");
    @VisibleForTesting
    static final TypeSignature SFIXED32 = TypeSignature.ofBase((String)"sfixed32");
    @VisibleForTesting
    static final TypeSignature SFIXED64 = TypeSignature.ofBase((String)"sfixed64");
    @VisibleForTesting
    static final TypeSignature STRING = TypeSignature.ofBase((String)"string");
    @VisibleForTesting
    static final TypeSignature BYTES = TypeSignature.ofBase((String)"bytes");
    @VisibleForTesting
    static final TypeSignature UNKNOWN = TypeSignature.ofBase((String)"unknown");

    @Nullable
    public NamedTypeInfo newNamedTypeInfo(Object typeDescriptor) {
        Objects.requireNonNull(typeDescriptor, "typeDescriptor");
        if (typeDescriptor instanceof Descriptors.Descriptor) {
            return ProtobufNamedTypeInfoProvider.newStructInfo((Descriptors.Descriptor)typeDescriptor);
        }
        if (typeDescriptor instanceof Descriptors.EnumDescriptor) {
            return ProtobufNamedTypeInfoProvider.newEnumInfo((Descriptors.EnumDescriptor)typeDescriptor);
        }
        if (!(typeDescriptor instanceof Class)) {
            return null;
        }
        Class clazz = (Class)typeDescriptor;
        if (!ProtobufRequestConverterFunctionProvider.isProtobufMessage(clazz)) {
            return null;
        }
        Message.Builder messageBuilder = ProtobufRequestConverterFunction.getMessageBuilder(clazz);
        Descriptors.Descriptor descriptorForType = messageBuilder.getDescriptorForType();
        return ProtobufNamedTypeInfoProvider.newStructInfo(descriptorForType).withAlias(clazz.getName());
    }

    public static StructInfo newStructInfo(Descriptors.Descriptor descriptor) {
        Objects.requireNonNull(descriptor, "descriptor");
        HashSet<Descriptors.Descriptor> visiting = new HashSet<Descriptors.Descriptor>();
        visiting.add(descriptor);
        return new StructInfo(descriptor.getFullName(), ProtobufNamedTypeInfoProvider.newFieldInfos(descriptor, visiting));
    }

    private static List<FieldInfo> newFieldInfos(Descriptors.Descriptor descriptor, Set<Descriptors.Descriptor> visiting) {
        return (List)descriptor.getFields().stream().map(fieldDescriptor -> ProtobufNamedTypeInfoProvider.newFieldInfo(fieldDescriptor, visiting)).collect(ImmutableList.toImmutableList());
    }

    private static FieldInfo newFieldInfo(Descriptors.FieldDescriptor fieldDescriptor, Set<Descriptors.Descriptor> visiting) {
        TypeSignature typeSignature = ProtobufNamedTypeInfoProvider.newFieldTypeInfo(fieldDescriptor);
        Object typeDescriptor = typeSignature.namedTypeDescriptor();
        FieldInfoBuilder builder = typeDescriptor instanceof Descriptors.Descriptor && visiting.add((Descriptors.Descriptor)typeDescriptor) ? FieldInfo.builder((String)fieldDescriptor.getName(), (TypeSignature)typeSignature, ProtobufNamedTypeInfoProvider.newFieldInfos((Descriptors.Descriptor)typeDescriptor, visiting)) : FieldInfo.builder((String)fieldDescriptor.getName(), (TypeSignature)typeSignature);
        FieldInfo fieldInfo = builder.requirement(fieldDescriptor.isRequired() ? FieldRequirement.REQUIRED : FieldRequirement.OPTIONAL).build();
        visiting.remove(typeDescriptor);
        return fieldInfo;
    }

    @VisibleForTesting
    static TypeSignature newFieldTypeInfo(Descriptors.FieldDescriptor fieldDescriptor) {
        TypeSignature fieldType;
        if (fieldDescriptor.isMapField()) {
            return TypeSignature.ofMap((TypeSignature)ProtobufNamedTypeInfoProvider.newFieldTypeInfo(fieldDescriptor.getMessageType().findFieldByNumber(1)), (TypeSignature)ProtobufNamedTypeInfoProvider.newFieldTypeInfo(fieldDescriptor.getMessageType().findFieldByNumber(2)));
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                fieldType = BOOL;
                break;
            }
            case BYTES: {
                fieldType = BYTES;
                break;
            }
            case DOUBLE: {
                fieldType = DOUBLE;
                break;
            }
            case FIXED32: {
                fieldType = FIXED32;
                break;
            }
            case FIXED64: {
                fieldType = FIXED64;
                break;
            }
            case FLOAT: {
                fieldType = FLOAT;
                break;
            }
            case INT32: {
                fieldType = INT32;
                break;
            }
            case INT64: {
                fieldType = INT64;
                break;
            }
            case SFIXED32: {
                fieldType = SFIXED32;
                break;
            }
            case SFIXED64: {
                fieldType = SFIXED64;
                break;
            }
            case SINT32: {
                fieldType = SINT32;
                break;
            }
            case SINT64: {
                fieldType = SINT64;
                break;
            }
            case STRING: {
                fieldType = STRING;
                break;
            }
            case UINT32: {
                fieldType = UINT32;
                break;
            }
            case UINT64: {
                fieldType = UINT64;
                break;
            }
            case MESSAGE: {
                fieldType = ProtobufNamedTypeInfoProvider.namedMessageSignature(fieldDescriptor.getMessageType());
                break;
            }
            case GROUP: {
                fieldType = UNKNOWN;
                break;
            }
            case ENUM: {
                fieldType = TypeSignature.ofNamed((String)fieldDescriptor.getEnumType().getFullName(), (Object)fieldDescriptor.getEnumType());
                break;
            }
            default: {
                fieldType = UNKNOWN;
            }
        }
        return fieldDescriptor.isRepeated() ? TypeSignature.ofContainer((String)"repeated", (TypeSignature[])new TypeSignature[]{fieldType}) : fieldType;
    }

    private static TypeSignature namedMessageSignature(Descriptors.Descriptor descriptor) {
        return TypeSignature.ofNamed((String)descriptor.getFullName(), (Object)descriptor);
    }

    @VisibleForTesting
    static EnumInfo newEnumInfo(Descriptors.EnumDescriptor enumDescriptor) {
        return new EnumInfo(enumDescriptor.getFullName(), (Iterable)enumDescriptor.getValues().stream().map(d -> new EnumValueInfo(d.getName(), Integer.valueOf(d.getNumber()))).collect(ImmutableList.toImmutableList()));
    }
}

