/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.protobuf;

import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.linecorp.armeria.internal.server.annotation.ClassUtil;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunctionProvider;
import com.linecorp.armeria.server.protobuf.ProtobufResponseConverterFunction;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;

public final class ProtobufResponseConverterFunctionProvider
implements ResponseConverterFunctionProvider {
    public ResponseConverterFunction createResponseConverterFunction(Type returnType) {
        if (ProtobufResponseConverterFunctionProvider.isSupportedType(returnType)) {
            return new ProtobufResponseConverterFunction();
        }
        return null;
    }

    private static boolean isSupportedType(Type type) {
        if ((type = ClassUtil.unwrapUnaryAsyncType((Type)type)) instanceof Class) {
            return MessageLite.class.isAssignableFrom((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            if (Iterable.class.isAssignableFrom(rawType) || Stream.class.isAssignableFrom(rawType) || Publisher.class.isAssignableFrom(rawType)) {
                Class typeArgument = (Class)parameterizedType.getActualTypeArguments()[0];
                return Message.class.isAssignableFrom(typeArgument);
            }
            if (Map.class.isAssignableFrom(rawType)) {
                Class typeArgument = (Class)parameterizedType.getActualTypeArguments()[1];
                return Message.class.isAssignableFrom(typeArgument);
            }
        }
        return false;
    }
}

