/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.resilience4j.circuitbreaker.client;

import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.circuitbreaker.CircuitBreakerCallback;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.resilience4j.circuitbreaker.FailedCircuitBreakerDecisionException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.util.Objects;

final class Resilience4JCircuitBreakerCallback
implements CircuitBreakerCallback {
    private final CircuitBreaker circuitBreaker;
    private final long startTimestamp;

    Resilience4JCircuitBreakerCallback(CircuitBreaker circuitBreaker, long startTimestamp) {
        this.circuitBreaker = Objects.requireNonNull(circuitBreaker, "circuitBreaker");
        this.startTimestamp = startTimestamp;
    }

    public void onSuccess(RequestContext ctx) {
        long duration = this.circuitBreaker.getCurrentTimestamp() - this.startTimestamp;
        this.circuitBreaker.onSuccess(duration, this.circuitBreaker.getTimestampUnit());
    }

    public void onFailure(RequestContext ctx, @Nullable Throwable cause) {
        long duration = this.circuitBreaker.getCurrentTimestamp() - this.startTimestamp;
        if (cause == null) {
            RequestLog requestLog = ctx.log().getIfAvailable(new RequestLogProperty[]{RequestLogProperty.RESPONSE_CAUSE});
            Throwable throwable = cause = requestLog != null ? requestLog.responseCause() : null;
        }
        if (cause == null) {
            cause = FailedCircuitBreakerDecisionException.of();
        }
        this.circuitBreaker.onError(duration, this.circuitBreaker.getTimestampUnit(), cause);
    }
}

