/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.resilience4j.circuitbreaker.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.UnprocessedRequestException;
import com.linecorp.armeria.client.circuitbreaker.CircuitBreakerClientHandler;
import com.linecorp.armeria.client.circuitbreaker.ClientCircuitBreakerGenerator;
import com.linecorp.armeria.common.Request;
import com.linecorp.armeria.common.annotation.UnstableApi;
import com.linecorp.armeria.common.circuitbreaker.CircuitBreakerCallback;
import com.linecorp.armeria.resilience4j.circuitbreaker.client.Resilience4JCircuitBreakerCallback;
import com.linecorp.armeria.resilience4j.circuitbreaker.client.Resilience4jCircuitBreakerMapping;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnstableApi
public final class Resilience4JCircuitBreakerClientHandler
implements CircuitBreakerClientHandler {
    private static final Logger logger = LoggerFactory.getLogger(Resilience4JCircuitBreakerClientHandler.class);
    private final ClientCircuitBreakerGenerator<CircuitBreaker> mapping;

    public static CircuitBreakerClientHandler of() {
        return Resilience4JCircuitBreakerClientHandler.of(Resilience4jCircuitBreakerMapping.of());
    }

    public static CircuitBreakerClientHandler of(CircuitBreaker circuitBreaker) {
        Objects.requireNonNull(circuitBreaker, "circuitBreaker");
        return Resilience4JCircuitBreakerClientHandler.of((ClientRequestContext ctx, Request req) -> circuitBreaker);
    }

    public static CircuitBreakerClientHandler of(Resilience4jCircuitBreakerMapping mapping) {
        return new Resilience4JCircuitBreakerClientHandler((ClientCircuitBreakerGenerator<CircuitBreaker>)((ClientCircuitBreakerGenerator)Objects.requireNonNull(mapping, "mapping")));
    }

    Resilience4JCircuitBreakerClientHandler(ClientCircuitBreakerGenerator<CircuitBreaker> mapping) {
        this.mapping = mapping;
    }

    public CircuitBreakerCallback tryRequest(ClientRequestContext ctx, Request req) {
        CircuitBreaker circuitBreaker;
        try {
            circuitBreaker = Objects.requireNonNull((CircuitBreaker)this.mapping.get(ctx, req), "circuitBreaker");
        }
        catch (Throwable t) {
            logger.warn("Failed to get a circuit breaker from mapping ({}) for context ({})", new Object[]{this.mapping, ctx, t});
            return null;
        }
        try {
            circuitBreaker.acquirePermission();
        }
        catch (CallNotPermittedException e) {
            throw UnprocessedRequestException.of((Throwable)e);
        }
        long startTimestamp = circuitBreaker.getCurrentTimestamp();
        return new Resilience4JCircuitBreakerCallback(circuitBreaker, startTimestamp);
    }

    public boolean isCircuitBreakerException(Exception ex) {
        return ex instanceof UnprocessedRequestException && ex.getCause() instanceof CallNotPermittedException;
    }
}

