/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retrofit2;

import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.retrofit2.CompletableCallback;
import com.linecorp.armeria.client.retrofit2.InvocationUtil;
import com.linecorp.armeria.client.retrofit2.SubscriberFactory;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import java.io.IOException;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.BiFunction;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;
import okio.Timeout;
import retrofit2.Invocation;

final class ArmeriaCallFactory
implements Call.Factory {
    private final String baseWebClientHost;
    private final int baseWebClientPort;
    private final WebClient baseWebClient;
    private final SubscriberFactory subscriberFactory;
    private final BiFunction<SessionProtocol, Endpoint, WebClient> nonBaseWebClientFactory;

    ArmeriaCallFactory(String baseWebClientHost, int baseWebClientPort, WebClient baseWebClient, SubscriberFactory subscriberFactory, BiFunction<? super SessionProtocol, ? super Endpoint, ? extends WebClient> nonBaseWebClientFactory) {
        this.baseWebClientHost = baseWebClientHost;
        this.baseWebClientPort = baseWebClientPort;
        this.baseWebClient = baseWebClient;
        this.subscriberFactory = subscriberFactory;
        BiFunction<? super SessionProtocol, ? super Endpoint, ? extends WebClient> castNonBaseWebClientFactory = nonBaseWebClientFactory;
        this.nonBaseWebClientFactory = castNonBaseWebClientFactory;
    }

    public Call newCall(Request request) {
        return new ArmeriaCall(this, request);
    }

    WebClient getWebClient(HttpUrl url) {
        if (this.baseWebClient.scheme().sessionProtocol().isTls() == url.isHttps() && this.baseWebClientHost.equals(url.host()) && this.baseWebClientPort == url.port()) {
            return this.baseWebClient;
        }
        SessionProtocol protocol = url.isHttps() ? SessionProtocol.HTTPS : SessionProtocol.HTTP;
        Endpoint endpoint = Endpoint.unsafeCreate((String)url.host(), (int)url.port());
        return this.nonBaseWebClientFactory.apply(protocol, endpoint);
    }

    static class ArmeriaCall
    implements Call {
        private static final AtomicReferenceFieldUpdater<ArmeriaCall, ExecutionState> executionStateUpdater = AtomicReferenceFieldUpdater.newUpdater(ArmeriaCall.class, ExecutionState.class, "executionState");
        private final ArmeriaCallFactory callFactory;
        private final Request request;
        @Nullable
        private volatile HttpResponse httpResponse;
        private volatile ExecutionState executionState = ExecutionState.IDLE;

        ArmeriaCall(ArmeriaCallFactory callFactory, Request request) {
            this.callFactory = callFactory;
            this.request = request;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        private static HttpResponse doCall(ArmeriaCallFactory callFactory, Request request) {
            HttpUrl httpUrl = request.url();
            WebClient webClient = callFactory.getWebClient(httpUrl);
            String absolutePathRef = httpUrl.encodedQuery() == null ? httpUrl.encodedPath() : httpUrl.encodedPath() + '?' + httpUrl.encodedQuery();
            RequestHeadersBuilder headers = RequestHeaders.builder((HttpMethod)HttpMethod.valueOf((String)request.method()), (String)absolutePathRef);
            Headers requestHeaders = request.headers();
            int numHeaders = requestHeaders.size();
            for (int i = 0; i < numHeaders; ++i) {
                headers.add((CharSequence)HttpHeaderNames.of((CharSequence)requestHeaders.name(i)), requestHeaders.value(i));
            }
            RequestBody body = request.body();
            Invocation invocation = (Invocation)request.tag(Invocation.class);
            if (body == null) {
                try (SafeCloseable ignored = Clients.withContextCustomizer(ctx -> InvocationUtil.setInvocation(ctx, invocation));){
                    HttpResponse httpResponse = webClient.execute(headers.build());
                    return httpResponse;
                }
            }
            MediaType contentType = body.contentType();
            if (contentType != null) {
                headers.set((CharSequence)HttpHeaderNames.CONTENT_TYPE, contentType.toString());
            }
            try (Buffer contentBuffer = new Buffer();){
                HttpResponse httpResponse;
                block22: {
                    body.writeTo((BufferedSink)contentBuffer);
                    SafeCloseable ignored = Clients.withContextCustomizer(ctx -> InvocationUtil.setInvocation(ctx, invocation));
                    try {
                        httpResponse = webClient.execute(headers.build(), contentBuffer.readByteArray());
                        if (ignored == null) break block22;
                    }
                    catch (Throwable throwable) {
                        if (ignored != null) {
                            try {
                                ignored.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    ignored.close();
                }
                return httpResponse;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Failed to convert RequestBody to HttpData. " + request.method(), e);
            }
        }

        public Request request() {
            return this.request;
        }

        private synchronized void createRequest() {
            if (this.httpResponse != null) {
                throw new IllegalStateException("executed already");
            }
            executionStateUpdater.compareAndSet(this, ExecutionState.IDLE, ExecutionState.RUNNING);
            this.httpResponse = ArmeriaCall.doCall(this.callFactory, this.request);
        }

        public Response execute() throws IOException {
            CompletableCallback completableCallback = new CompletableCallback();
            this.enqueue(completableCallback);
            try {
                return (Response)completableCallback.join();
            }
            catch (CancellationException e) {
                throw new IOException(e);
            }
            catch (CompletionException e) {
                throw new IOException(Exceptions.peel((Throwable)e));
            }
        }

        public void enqueue(Callback callback) {
            this.createRequest();
            this.httpResponse.subscribe(this.callFactory.subscriberFactory.create(this, callback, this.request));
        }

        public void cancel() {
            executionStateUpdater.set(this, ExecutionState.CANCELED);
        }

        public boolean isExecuted() {
            return this.httpResponse != null;
        }

        public boolean isCanceled() {
            return this.executionState == ExecutionState.CANCELED;
        }

        public Timeout timeout() {
            return Timeout.NONE;
        }

        boolean tryFinish() {
            return executionStateUpdater.compareAndSet(this, ExecutionState.IDLE, ExecutionState.FINISHED) || executionStateUpdater.compareAndSet(this, ExecutionState.RUNNING, ExecutionState.FINISHED);
        }

        public Call clone() {
            return new ArmeriaCall(this.callFactory, this.request);
        }

        private static enum ExecutionState {
            IDLE,
            RUNNING,
            CANCELED,
            FINISHED;

        }
    }
}

