/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retrofit2;

import com.linecorp.armeria.client.retrofit2.ArmeriaCallFactory;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Strings;
import com.linecorp.armeria.unsafe.PooledObjects;
import io.netty.util.AsciiString;
import java.io.IOException;
import java.util.concurrent.Executor;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.MediaType;
import okhttp3.Protocol;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

abstract class AbstractSubscriber
implements Subscriber<HttpObject> {
    private static final long NO_CONTENT_LENGTH = -1L;
    private final Response.Builder responseBuilder = new Response.Builder();
    private final ArmeriaCallFactory.ArmeriaCall armeriaCall;
    private final Callback callback;
    private final Executor callbackExecutor;
    @Nullable
    private Subscription subscription;
    private boolean callbackCalled;
    @Nullable
    private String contentType;
    private long contentLength = -1L;
    private State state = State.WAIT_NON_INFORMATIONAL;

    AbstractSubscriber(ArmeriaCallFactory.ArmeriaCall armeriaCall, Request request, Callback callback, Executor callbackExecutor) {
        this.armeriaCall = armeriaCall;
        this.callback = callback;
        this.callbackExecutor = callbackExecutor;
        this.responseBuilder.request(request).protocol(Protocol.HTTP_1_1);
    }

    public final void onSubscribe(Subscription subscription) {
        this.subscription = subscription;
        if (this.armeriaCall.isCanceled()) {
            this.onCancelled();
            subscription.cancel();
            return;
        }
        this.onSubscribe0();
    }

    public final void onNext(HttpObject httpObject) {
        if (this.armeriaCall.isCanceled()) {
            this.onCancelled();
            assert (this.subscription != null);
            this.subscription.cancel();
            return;
        }
        switch (this.state) {
            case WAIT_NON_INFORMATIONAL: {
                HttpStatus status;
                assert (httpObject instanceof HttpHeaders);
                HttpHeaders headers = (HttpHeaders)httpObject;
                this.onHttpHeaders();
                String statusText = headers.get((CharSequence)HttpHeaderNames.STATUS);
                if (statusText == null || (status = HttpStatus.valueOf((String)statusText)).isInformational()) break;
                this.state = State.WAIT_DATA_OR_TRAILERS;
                this.responseBuilder.code(status.code());
                this.responseBuilder.message(status.reasonPhrase());
                headers.forEach(header -> this.responseBuilder.addHeader(((AsciiString)header.getKey()).toString(), (String)header.getValue()));
                this.contentType = headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE);
                this.contentLength = headers.contentLength();
                break;
            }
            case WAIT_DATA_OR_TRAILERS: {
                if (httpObject instanceof HttpHeaders) {
                    this.onHttpHeaders();
                    this.state = State.DONE;
                    break;
                }
                this.onHttpData((HttpData)httpObject);
                break;
            }
            case DONE: {
                assert (this.subscription != null);
                this.subscription.cancel();
                PooledObjects.close((Object)httpObject);
            }
        }
    }

    public final void onError(Throwable throwable) {
        if (this.armeriaCall.tryFinish()) {
            this.onError0(new IOException(throwable.toString(), throwable));
        } else {
            this.onError0(AbstractSubscriber.newCancelledException());
        }
    }

    public final void onComplete() {
        if (this.armeriaCall.tryFinish()) {
            this.onComplete0();
        } else {
            this.onError0(AbstractSubscriber.newCancelledException());
        }
    }

    final void cancel() {
        assert (this.subscription != null);
        this.subscription.cancel();
    }

    final void request(long n) {
        assert (this.subscription != null);
        this.subscription.request(n);
    }

    final void safeOnFailure(IOException e) {
        if (this.callbackCalled) {
            return;
        }
        this.callbackCalled = true;
        this.callbackExecutor.execute(() -> this.callback.onFailure((Call)this.armeriaCall, e));
    }

    final void safeOnResponse(BufferedSource content) {
        if (this.callbackCalled) {
            return;
        }
        this.callbackCalled = true;
        this.callbackExecutor.execute(() -> {
            try {
                this.callback.onResponse((Call)this.armeriaCall, this.responseBuilder.body(ResponseBody.create((MediaType)(Strings.isNullOrEmpty((String)this.contentType) ? null : MediaType.parse((String)this.contentType)), (long)this.contentLength, (BufferedSource)content)).build());
            }
            catch (IOException e) {
                this.callback.onFailure((Call)this.armeriaCall, e);
            }
        });
    }

    abstract void onSubscribe0();

    abstract void onCancelled();

    abstract void onHttpHeaders();

    abstract void onHttpData(HttpData var1);

    abstract void onError0(IOException var1);

    abstract void onComplete0();

    static IOException newCancelledException() {
        return new IOException("cancelled");
    }

    static enum State {
        WAIT_NON_INFORMATIONAL,
        WAIT_DATA_OR_TRAILERS,
        DONE;

    }
}

