/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retrofit2;

import com.linecorp.armeria.client.Clients;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.retrofit2.ArmeriaRetrofitBuilder;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.net.URI;
import java.util.Objects;
import retrofit2.Retrofit;

public final class ArmeriaRetrofit {
    public static Retrofit of(String baseUrl) {
        return ArmeriaRetrofit.builder(baseUrl).build();
    }

    public static Retrofit of(URI baseUrl) {
        return ArmeriaRetrofit.builder(baseUrl).build();
    }

    public static Retrofit of(String protocol, EndpointGroup endpointGroup) {
        return ArmeriaRetrofit.builder(protocol, endpointGroup).build();
    }

    public static Retrofit of(SessionProtocol protocol, EndpointGroup endpointGroup) {
        return ArmeriaRetrofit.builder(protocol, endpointGroup).build();
    }

    public static Retrofit of(String protocol, EndpointGroup endpointGroup, String path) {
        return ArmeriaRetrofit.builder(protocol, endpointGroup, path).build();
    }

    public static Retrofit of(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        return ArmeriaRetrofit.builder(protocol, endpointGroup, path).build();
    }

    public static Retrofit of(WebClient baseWebClient) {
        return ArmeriaRetrofit.builder(baseWebClient).build();
    }

    public static ArmeriaRetrofitBuilder builder(String baseUrl) {
        Objects.requireNonNull(baseUrl, "baseUrl");
        return ArmeriaRetrofit.builder(WebClient.of((String)baseUrl));
    }

    public static ArmeriaRetrofitBuilder builder(URI baseUrl) {
        Objects.requireNonNull(baseUrl, "baseUrl");
        return ArmeriaRetrofit.builder(WebClient.of((URI)baseUrl));
    }

    public static ArmeriaRetrofitBuilder builder(String protocol, EndpointGroup endpointGroup) {
        return ArmeriaRetrofit.builder(SessionProtocol.of((String)Objects.requireNonNull(protocol, "protocol")), endpointGroup);
    }

    public static ArmeriaRetrofitBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        return ArmeriaRetrofit.builder(WebClient.of((SessionProtocol)protocol, (EndpointGroup)endpointGroup));
    }

    public static ArmeriaRetrofitBuilder builder(String protocol, EndpointGroup endpointGroup, String path) {
        return ArmeriaRetrofit.builder(SessionProtocol.of((String)Objects.requireNonNull(protocol, "protocol")), endpointGroup, path);
    }

    public static ArmeriaRetrofitBuilder builder(SessionProtocol protocol, EndpointGroup endpointGroup, String path) {
        Objects.requireNonNull(protocol, "protocol");
        Objects.requireNonNull(endpointGroup, "endpointGroup");
        Objects.requireNonNull(path, "path");
        return ArmeriaRetrofit.builder(WebClient.of((SessionProtocol)protocol, (EndpointGroup)endpointGroup, (String)path));
    }

    public static ArmeriaRetrofitBuilder builder(WebClient baseWebClient) {
        Objects.requireNonNull(baseWebClient, "baseWebClient");
        Preconditions.checkArgument((!Clients.isUndefinedUri((URI)baseWebClient.uri()) ? 1 : 0) != 0, (Object)"baseWebClient must have base URL.");
        return new ArmeriaRetrofitBuilder(baseWebClient);
    }

    private ArmeriaRetrofit() {
    }
}

