/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retrofit2;

import com.linecorp.armeria.common.annotation.Nullable;
import java.io.IOException;
import okio.Buffer;
import okio.Source;
import okio.Timeout;

final class PipeBuffer {
    private final Buffer buffer = new Buffer();
    private final PipeSource source = new PipeSource();
    private boolean sinkClosed;
    private boolean sourceClosed;
    @Nullable
    private Throwable sinkClosedException;

    PipeBuffer() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(byte[] source, int offset, int byteCount) {
        if (byteCount == 0) {
            return;
        }
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (this.sourceClosed) {
                return;
            }
            if (this.sinkClosed) {
                throw new IllegalStateException("closed");
            }
            this.buffer.write(source, offset, byteCount);
            this.buffer.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close(@Nullable Throwable throwable) {
        Buffer buffer = this.buffer;
        synchronized (buffer) {
            if (this.sinkClosed) {
                return;
            }
            this.sinkClosed = true;
            this.sinkClosedException = throwable;
            this.buffer.notifyAll();
        }
    }

    Source source() {
        return this.source;
    }

    private final class PipeSource
    implements Source {
        final Timeout timeout = new Timeout();

        private PipeSource() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long read(Buffer sink, long byteCount) throws IOException {
            Buffer buffer = PipeBuffer.this.buffer;
            synchronized (buffer) {
                if (PipeBuffer.this.sourceClosed) {
                    throw new IllegalStateException("closed");
                }
                while (PipeBuffer.this.buffer.size() == 0L) {
                    if (PipeBuffer.this.sinkClosed) {
                        if (PipeBuffer.this.sinkClosedException == null) {
                            return -1L;
                        }
                        throw new IOException(PipeBuffer.this.sinkClosedException);
                    }
                    this.timeout.waitUntilNotified((Object)PipeBuffer.this.buffer);
                }
                long result = PipeBuffer.this.buffer.read(sink, byteCount);
                PipeBuffer.this.buffer.notifyAll();
                return result;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() throws IOException {
            Buffer buffer = PipeBuffer.this.buffer;
            synchronized (buffer) {
                PipeBuffer.this.sourceClosed = true;
                PipeBuffer.this.buffer.notifyAll();
            }
        }

        public Timeout timeout() {
            return this.timeout;
        }
    }
}

