/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retrofit2;

import com.linecorp.armeria.client.AbstractClientOptionsBuilder;
import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOption;
import com.linecorp.armeria.client.ClientOptionValue;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.client.DecoratingHttpClientFunction;
import com.linecorp.armeria.client.DecoratingRpcClientFunction;
import com.linecorp.armeria.client.Endpoint;
import com.linecorp.armeria.client.HttpClient;
import com.linecorp.armeria.client.RpcClient;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.redirect.RedirectConfig;
import com.linecorp.armeria.client.retrofit2.ArmeriaCallFactory;
import com.linecorp.armeria.client.retrofit2.SubscriberFactory;
import com.linecorp.armeria.common.CommonPools;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.auth.AuthToken;
import com.linecorp.armeria.common.auth.BasicToken;
import com.linecorp.armeria.common.auth.OAuth1aToken;
import com.linecorp.armeria.common.auth.OAuth2Token;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import java.net.URI;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import okhttp3.Call;
import okhttp3.HttpUrl;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;

public final class ArmeriaRetrofitBuilder
extends AbstractClientOptionsBuilder {
    private final Retrofit.Builder retrofitBuilder;
    private final String baseWebClientHost;
    private final int baseWebClientPort;
    private final WebClient webClient;
    private boolean streaming;
    private Executor callbackExecutor = CommonPools.blockingTaskExecutor();
    @Nullable
    private BiFunction<? super SessionProtocol, ? super Endpoint, ? extends WebClient> nonBaseClientFactory;

    ArmeriaRetrofitBuilder(WebClient webClient) {
        this.webClient = webClient;
        URI uri = webClient.uri();
        SessionProtocol protocol = webClient.scheme().sessionProtocol();
        HttpUrl baseUrl = HttpUrl.get((String)((protocol.isTls() ? "https" : "http") + uri.toString().substring(protocol.uriText().length())));
        this.retrofitBuilder = new Retrofit.Builder().baseUrl(baseUrl);
        this.baseWebClientHost = baseUrl.host();
        this.baseWebClientPort = baseUrl.port();
    }

    public ArmeriaRetrofitBuilder nonBaseClientFactory(BiFunction<? super SessionProtocol, ? super Endpoint, ? extends WebClient> nonBaseClientFactory) {
        this.nonBaseClientFactory = Objects.requireNonNull(nonBaseClientFactory, "nonBaseClientFactory");
        return this;
    }

    public ArmeriaRetrofitBuilder addConverterFactory(Converter.Factory factory) {
        this.retrofitBuilder.addConverterFactory(Objects.requireNonNull(factory, "factory"));
        return this;
    }

    public ArmeriaRetrofitBuilder addCallAdapterFactory(CallAdapter.Factory factory) {
        this.retrofitBuilder.addCallAdapterFactory(Objects.requireNonNull(factory, "factory"));
        return this;
    }

    public ArmeriaRetrofitBuilder callbackExecutor(Executor executor) {
        this.callbackExecutor = Objects.requireNonNull(executor, "executor");
        this.retrofitBuilder.callbackExecutor(this.callbackExecutor);
        return this;
    }

    public ArmeriaRetrofitBuilder streaming(boolean streaming) {
        this.streaming = streaming;
        return this;
    }

    public ArmeriaRetrofitBuilder validateEagerly(boolean validateEagerly) {
        this.retrofitBuilder.validateEagerly(validateEagerly);
        return this;
    }

    public Retrofit build() {
        SessionProtocol protocol = this.webClient.scheme().sessionProtocol();
        ClientOptions retrofitOptions = this.buildOptions(this.webClient.options());
        WebClient baseWebClient = WebClient.builder((SessionProtocol)protocol, (EndpointGroup)this.webClient.endpointGroup()).options(retrofitOptions).build();
        if (this.nonBaseClientFactory == null) {
            this.nonBaseClientFactory = (p, url) -> WebClient.builder((SessionProtocol)p, (EndpointGroup)Endpoint.unsafeCreate((String)url.host(), (int)url.port())).options(retrofitOptions).build();
        }
        this.retrofitBuilder.callFactory((Call.Factory)new ArmeriaCallFactory(this.baseWebClientHost, this.baseWebClientPort, baseWebClient, this.streaming ? SubscriberFactory.streaming(this.callbackExecutor) : SubscriberFactory.blocking(), new CachedNonBaseClientFactory(this.nonBaseClientFactory)));
        return this.retrofitBuilder.build();
    }

    public ArmeriaRetrofitBuilder options(ClientOptions options) {
        return (ArmeriaRetrofitBuilder)super.options(options);
    }

    public ArmeriaRetrofitBuilder options(ClientOptionValue<?> ... options) {
        return (ArmeriaRetrofitBuilder)super.options(options);
    }

    public ArmeriaRetrofitBuilder options(Iterable<ClientOptionValue<?>> options) {
        return (ArmeriaRetrofitBuilder)super.options(options);
    }

    public <T> ArmeriaRetrofitBuilder option(ClientOption<T> option, T value) {
        return (ArmeriaRetrofitBuilder)super.option(option, value);
    }

    public <T> ArmeriaRetrofitBuilder option(ClientOptionValue<T> optionValue) {
        return (ArmeriaRetrofitBuilder)super.option(optionValue);
    }

    public ArmeriaRetrofitBuilder factory(ClientFactory factory) {
        return (ArmeriaRetrofitBuilder)super.factory(factory);
    }

    public ArmeriaRetrofitBuilder writeTimeout(Duration writeTimeout) {
        return (ArmeriaRetrofitBuilder)super.writeTimeout(writeTimeout);
    }

    public ArmeriaRetrofitBuilder writeTimeoutMillis(long writeTimeoutMillis) {
        return (ArmeriaRetrofitBuilder)super.writeTimeoutMillis(writeTimeoutMillis);
    }

    public ArmeriaRetrofitBuilder responseTimeout(Duration responseTimeout) {
        return (ArmeriaRetrofitBuilder)super.responseTimeout(responseTimeout);
    }

    public ArmeriaRetrofitBuilder responseTimeoutMillis(long responseTimeoutMillis) {
        return (ArmeriaRetrofitBuilder)super.responseTimeoutMillis(responseTimeoutMillis);
    }

    public ArmeriaRetrofitBuilder maxResponseLength(long maxResponseLength) {
        return (ArmeriaRetrofitBuilder)super.maxResponseLength(maxResponseLength);
    }

    public ArmeriaRetrofitBuilder requestIdGenerator(Supplier<RequestId> requestIdGenerator) {
        return (ArmeriaRetrofitBuilder)super.requestIdGenerator(requestIdGenerator);
    }

    public ArmeriaRetrofitBuilder successFunction(SuccessFunction successFunction) {
        return (ArmeriaRetrofitBuilder)super.successFunction(successFunction);
    }

    public ArmeriaRetrofitBuilder endpointRemapper(Function<? super Endpoint, ? extends EndpointGroup> endpointRemapper) {
        return (ArmeriaRetrofitBuilder)super.endpointRemapper(endpointRemapper);
    }

    public ArmeriaRetrofitBuilder decorator(Function<? super HttpClient, ? extends HttpClient> decorator) {
        return (ArmeriaRetrofitBuilder)super.decorator(decorator);
    }

    public ArmeriaRetrofitBuilder decorator(DecoratingHttpClientFunction decorator) {
        return (ArmeriaRetrofitBuilder)super.decorator(decorator);
    }

    public ArmeriaRetrofitBuilder clearDecorators() {
        return (ArmeriaRetrofitBuilder)super.clearDecorators();
    }

    public ArmeriaRetrofitBuilder rpcDecorator(Function<? super RpcClient, ? extends RpcClient> decorator) {
        return (ArmeriaRetrofitBuilder)super.rpcDecorator(decorator);
    }

    public ArmeriaRetrofitBuilder rpcDecorator(DecoratingRpcClientFunction decorator) {
        return (ArmeriaRetrofitBuilder)super.rpcDecorator(decorator);
    }

    public ArmeriaRetrofitBuilder addHeader(CharSequence name, Object value) {
        return (ArmeriaRetrofitBuilder)super.addHeader(name, value);
    }

    public ArmeriaRetrofitBuilder addHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (ArmeriaRetrofitBuilder)super.addHeaders(headers);
    }

    public ArmeriaRetrofitBuilder setHeader(CharSequence name, Object value) {
        return (ArmeriaRetrofitBuilder)super.setHeader(name, value);
    }

    public ArmeriaRetrofitBuilder setHeaders(Iterable<? extends Map.Entry<? extends CharSequence, ?>> headers) {
        return (ArmeriaRetrofitBuilder)super.setHeaders(headers);
    }

    public ArmeriaRetrofitBuilder auth(BasicToken token) {
        return (ArmeriaRetrofitBuilder)super.auth(token);
    }

    public ArmeriaRetrofitBuilder auth(OAuth1aToken token) {
        return (ArmeriaRetrofitBuilder)super.auth(token);
    }

    public ArmeriaRetrofitBuilder auth(OAuth2Token token) {
        return (ArmeriaRetrofitBuilder)super.auth(token);
    }

    public ArmeriaRetrofitBuilder auth(AuthToken token) {
        return (ArmeriaRetrofitBuilder)super.auth(token);
    }

    public ArmeriaRetrofitBuilder followRedirects() {
        return (ArmeriaRetrofitBuilder)super.followRedirects();
    }

    public ArmeriaRetrofitBuilder followRedirects(RedirectConfig redirectConfig) {
        return (ArmeriaRetrofitBuilder)super.followRedirects(redirectConfig);
    }

    public ArmeriaRetrofitBuilder contextCustomizer(Consumer<? super ClientRequestContext> contextCustomizer) {
        return (ArmeriaRetrofitBuilder)super.contextCustomizer(contextCustomizer);
    }

    private static class CachedNonBaseClientFactory
    implements BiFunction<SessionProtocol, Endpoint, WebClient> {
        private final BiFunction<SessionProtocol, Endpoint, WebClient> nonBaseClientFactory;
        private final Cache<Map.Entry<SessionProtocol, Endpoint>, WebClient> cache;

        CachedNonBaseClientFactory(BiFunction<? super SessionProtocol, ? super Endpoint, ? extends WebClient> nonBaseClientFactory) {
            this.nonBaseClientFactory = nonBaseClientFactory;
            this.cache = Caffeine.newBuilder().maximumSize(8192L).build();
        }

        @Override
        public WebClient apply(SessionProtocol protocol, Endpoint endpoint) {
            Map.Entry key = Maps.immutableEntry((Object)protocol, (Object)endpoint);
            WebClient webClient = (WebClient)this.cache.get((Object)key, unused -> this.nonBaseClientFactory.apply(protocol, endpoint));
            Preconditions.checkState((webClient != null ? 1 : 0) != 0, (Object)"nonBaseClientFactory returned null.");
            return webClient;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("nonBaseClientFactory", this.nonBaseClientFactory).add("cache", this.cache).toString();
        }
    }
}

