/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retrofit2;

import com.linecorp.armeria.client.retrofit2.InvocationUtil;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import com.linecorp.armeria.internal.common.metric.DefaultMeterIdPrefixFunction;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import retrofit2.Invocation;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.HEAD;
import retrofit2.http.HTTP;
import retrofit2.http.OPTIONS;
import retrofit2.http.PATCH;
import retrofit2.http.POST;
import retrofit2.http.PUT;

public final class RetrofitMeterIdPrefixFunction
implements MeterIdPrefixFunction {
    private static final List<Class<?>> RETROFIT_ANNOTATIONS = ImmutableList.of(POST.class, PUT.class, PATCH.class, HEAD.class, GET.class, OPTIONS.class, HTTP.class, DELETE.class);
    private static final Map<Method, String> pathCache = new MapMaker().weakKeys().makeMap();
    private static final String NONE = "none";
    private final String name;

    public static RetrofitMeterIdPrefixFunction of(String name) {
        return new RetrofitMeterIdPrefixFunction(name);
    }

    private RetrofitMeterIdPrefixFunction(String name) {
        this.name = Objects.requireNonNull(name, "name");
    }

    public MeterIdPrefix activeRequestPrefix(MeterRegistry registry, RequestOnlyLog log) {
        ImmutableList.Builder tagListBuilder = ImmutableList.builderWithExpectedSize((int)4);
        RequestHeaders requestHeaders = log.requestHeaders();
        String httpMethod = requestHeaders.method().name();
        tagListBuilder.add((Object)Tag.of((String)"http.method", (String)httpMethod));
        RetrofitMeterIdPrefixFunction.addMethodPathAndService((ImmutableList.Builder<Tag>)tagListBuilder, log, requestHeaders);
        return new MeterIdPrefix(this.name, (Iterable)tagListBuilder.build());
    }

    public MeterIdPrefix completeRequestPrefix(MeterRegistry registry, RequestLog log) {
        ImmutableList.Builder tagListBuilder = ImmutableList.builderWithExpectedSize((int)5);
        RequestHeaders requestHeaders = log.requestHeaders();
        String httpMethod = requestHeaders.method().name();
        tagListBuilder.add((Object)Tag.of((String)"http.method", (String)httpMethod));
        DefaultMeterIdPrefixFunction.addHttpStatus((ImmutableList.Builder)tagListBuilder, (RequestLog)log);
        RetrofitMeterIdPrefixFunction.addMethodPathAndService((ImmutableList.Builder<Tag>)tagListBuilder, (RequestOnlyLog)log, requestHeaders);
        return new MeterIdPrefix(this.name, (Iterable)tagListBuilder.build());
    }

    private static void addMethodPathAndService(ImmutableList.Builder<Tag> tagListBuilder, RequestOnlyLog log, RequestHeaders requestHeaders) {
        String path;
        String serviceName;
        String methodName;
        Invocation invocation = InvocationUtil.getInvocation((RequestLogAccess)log);
        if (invocation != null) {
            Method method = invocation.method();
            methodName = method.getName();
            serviceName = method.getDeclaringClass().getName();
            path = RetrofitMeterIdPrefixFunction.getPathFromMethod(method);
        } else {
            methodName = requestHeaders.method().name();
            serviceName = NONE;
            path = requestHeaders.path();
        }
        tagListBuilder.add((Object)Tag.of((String)"method", (String)methodName));
        tagListBuilder.add((Object)Tag.of((String)"path", (String)path));
        tagListBuilder.add((Object)Tag.of((String)"service", (String)serviceName));
    }

    @VisibleForTesting
    static String getPathFromMethod(Method method) {
        String path = pathCache.get(method);
        if (path != null) {
            return path;
        }
        return pathCache.computeIfAbsent(method, key -> {
            for (Annotation annotation : method.getDeclaredAnnotations()) {
                if (!RETROFIT_ANNOTATIONS.contains(annotation.annotationType())) continue;
                if (annotation.annotationType().equals(HTTP.class)) {
                    HTTP http = (HTTP)annotation;
                    return http.path();
                }
                try {
                    Method valueMethod = annotation.annotationType().getMethod("value", new Class[0]);
                    return (String)valueMethod.invoke((Object)annotation, new Object[0]);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                    throw new IllegalStateException("Unexpected retrofit annotation: " + annotation.annotationType(), e);
                }
            }
            return NONE;
        });
    }
}

