/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retrofit2;

import com.linecorp.armeria.client.retrofit2.AbstractSubscriber;
import com.linecorp.armeria.client.retrofit2.ArmeriaCallFactory;
import com.linecorp.armeria.client.retrofit2.PipeBuffer;
import com.linecorp.armeria.common.HttpData;
import java.io.IOException;
import java.util.concurrent.Executor;
import okhttp3.Callback;
import okhttp3.Request;
import okio.Buffer;
import okio.BufferedSource;
import okio.ForwardingSource;
import okio.Okio;
import okio.Source;

final class StreamingCallSubscriber
extends AbstractSubscriber {
    private static final Buffer emptyBuffer = new Buffer();
    private final PipeBuffer pipeBuffer = new PipeBuffer();
    private boolean responseCalled;

    StreamingCallSubscriber(ArmeriaCallFactory.ArmeriaCall armeriaCall, Callback callback, Request request, Executor callbackExecutor) {
        super(armeriaCall, request, callback, callbackExecutor);
    }

    @Override
    void onSubscribe0() {
        this.request(1L);
    }

    @Override
    void onCancelled() {
        IOException canceledException = StreamingCallSubscriber.newCancelledException();
        this.safeOnFailure(canceledException);
        this.pipeBuffer.close(canceledException);
    }

    @Override
    void onHttpHeaders() {
        this.request(1L);
    }

    @Override
    void onHttpData(HttpData data) {
        if (!this.responseCalled) {
            this.safeOnResponse(Okio.buffer((Source)new ForwardingSource(this.pipeBuffer.source()){

                public long read(Buffer sink, long byteCount) throws IOException {
                    if (StreamingCallSubscriber.this.pipeBuffer.exhausted()) {
                        StreamingCallSubscriber.this.request(1L);
                    }
                    return super.read(sink, byteCount);
                }

                public void close() throws IOException {
                    StreamingCallSubscriber.this.cancel();
                    super.close();
                }
            }));
            this.responseCalled = true;
        }
        this.pipeBuffer.write(data.array(), 0, data.length());
    }

    @Override
    void onError0(IOException e) {
        this.safeOnFailure(e);
        this.pipeBuffer.close(e);
    }

    @Override
    void onComplete0() {
        if (!this.responseCalled) {
            this.safeOnResponse((BufferedSource)emptyBuffer);
            this.responseCalled = true;
        }
        this.pipeBuffer.close(null);
    }
}

