/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.client.retrofit2;

import com.linecorp.armeria.client.retrofit2.AbstractSubscriber;
import com.linecorp.armeria.client.retrofit2.ArmeriaCallFactory;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.internal.shaded.guava.util.concurrent.MoreExecutors;
import java.io.IOException;
import okhttp3.Callback;
import okhttp3.Request;
import okio.Buffer;
import okio.BufferedSource;

final class BlockingCallSubscriber
extends AbstractSubscriber {
    private final Buffer responseDataBuffer = new Buffer();

    BlockingCallSubscriber(ArmeriaCallFactory.ArmeriaCall armeriaCall, Callback callback, Request request) {
        super(armeriaCall, request, callback, MoreExecutors.directExecutor());
    }

    @Override
    public void onError0(IOException e) {
        this.safeOnFailure(e);
    }

    @Override
    public void onComplete0() {
        this.safeOnResponse((BufferedSource)this.responseDataBuffer);
    }

    @Override
    void onSubscribe0() {
        this.request(Long.MAX_VALUE);
    }

    @Override
    void onHttpData(HttpData data) {
        this.responseDataBuffer.write(data.array());
    }

    @Override
    void onHttpHeaders() {
    }

    @Override
    void onCancelled() {
        this.safeOnFailure(BlockingCallSubscriber.newCancelledException());
    }
}

