/*
 * Copyright 2018 LINE Corporation
 *
 * LINE Corporation licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package com.linecorp.armeria.server.saml;

import static java.util.Objects.requireNonNull;

import com.google.common.base.MoreObjects;

/**
 * A configuration for an assertion consumer service of a service provider.
 */
public final class SamlAssertionConsumerConfig {
    private final SamlEndpoint endpoint;
    private final boolean isDefault;

    SamlAssertionConsumerConfig(SamlEndpoint endpoint, boolean isDefault) {
        this.endpoint = requireNonNull(endpoint, "endpoint");
        this.isDefault = isDefault;
    }

    /**
     * Returns a {@link SamlEndpoint} that an assertion consumer service is to be bound to.
     */
    public SamlEndpoint endpoint() {
        return endpoint;
    }

    /**
     * Returns whether this configuration is a default.
     */
    public boolean isDefault() {
        return isDefault;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this)
                          .add("endpoint", endpoint)
                          .add("default", isDefault)
                          .toString();
    }
}
