/*
 * Copyright 2018 LINE Corporation
 *
 * LINE Corporation licenses this file to you under the Apache License,
 * version 2.0 (the "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at:
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */
package com.linecorp.armeria.server.saml;

import java.util.concurrent.CompletionStage;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.server.ServiceRequestContext;

/**
 * A {@link SamlIdentityProviderConfig} selector for the request.
 */
@FunctionalInterface
public interface SamlIdentityProviderConfigSelector {
    /**
     * Returns a {@link SamlIdentityProviderConfig} which is used for authenticating the request.
     */
    CompletionStage<SamlIdentityProviderConfig> select(SamlServiceProvider sp,
                                                       ServiceRequestContext ctx,
                                                       HttpRequest req);
}
