/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.AggregatedHttpRequest;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.QueryParamsBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.annotations.VisibleForTesting;
import com.linecorp.armeria.server.saml.InvalidSamlRequestException;
import com.linecorp.armeria.server.saml.SamlException;
import com.linecorp.armeria.server.saml.SamlIdentityProviderConfig;
import com.linecorp.armeria.server.saml.SamlMessageUtil;
import com.linecorp.armeria.server.saml.SamlService;
import io.netty.handler.codec.http.HttpHeaderValues;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.Objects;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterOutputStream;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.messaging.context.SAMLBindingContext;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.xmlsec.crypto.XMLSigningUtil;
import org.w3c.dom.Node;

final class HttpRedirectBindingUtil {
    private static final String DEFAULT_CACHE_CONTROL = String.join((CharSequence)",", new CharSequence[]{HttpHeaderValues.NO_CACHE, HttpHeaderValues.NO_STORE});
    private static final String DEFAULT_PRAGMA = HttpHeaderValues.NO_CACHE.toString();

    static ResponseHeaders headersWithLocation(String location) {
        return ResponseHeaders.of((HttpStatus)HttpStatus.FOUND, (CharSequence)HttpHeaderNames.LOCATION, (String)location, (CharSequence)HttpHeaderNames.CACHE_CONTROL, (String)DEFAULT_CACHE_CONTROL, (CharSequence)HttpHeaderNames.PRAGMA, (String)DEFAULT_PRAGMA);
    }

    static HttpResponse responseWithLocation(String location) {
        return HttpResponse.of((ResponseHeaders)HttpRedirectBindingUtil.headersWithLocation(location));
    }

    static String toRedirectionUrl(SAMLObject msg, String endpointUrl, String messageParamName, Credential signingCredential, String signatureAlgorithm, @Nullable String relayState) {
        Objects.requireNonNull(msg, "msg");
        Objects.requireNonNull(endpointUrl, "endpointUrl");
        Objects.requireNonNull(messageParamName, "messageParamName");
        Objects.requireNonNull(signingCredential, "signingCredential");
        Objects.requireNonNull(signatureAlgorithm, "signatureAlgorithm");
        QueryParamsBuilder params = QueryParams.builder();
        params.add(messageParamName, HttpRedirectBindingUtil.toDeflatedBase64(msg));
        if (relayState != null) {
            if (relayState.length() > 80) {
                throw new IllegalArgumentException("too long relayState string: " + relayState.length());
            }
            params.add("RelayState", relayState);
        }
        params.add("SigAlg", signatureAlgorithm);
        String input = params.toQueryString();
        String output = HttpRedirectBindingUtil.generateSignature(signingCredential, signatureAlgorithm, input);
        params.add("Signature", output);
        return endpointUrl + '?' + params.toQueryString();
    }

    private static void validateSignature(Credential validationCredential, SamlService.SamlParameters parameters, String messageParamName) {
        Objects.requireNonNull(validationCredential, "validationCredential");
        Objects.requireNonNull(parameters, "parameters");
        Objects.requireNonNull(messageParamName, "messageParamName");
        String signature = parameters.getFirstValue("Signature");
        String sigAlg = parameters.getFirstValue("SigAlg");
        QueryParamsBuilder params = QueryParams.builder();
        params.add(messageParamName, parameters.getFirstValue(messageParamName));
        String relayState = parameters.getFirstValueOrNull("RelayState");
        if (relayState != null) {
            params.add("RelayState", relayState);
        }
        params.add("SigAlg", sigAlg);
        byte[] input = params.toQueryString().getBytes(StandardCharsets.UTF_8);
        try {
            byte[] decodedSignature = Base64.getMimeDecoder().decode(signature);
            if (!XMLSigningUtil.verifyWithURI((Credential)validationCredential, (String)sigAlg, (byte[])decodedSignature, (byte[])input)) {
                throw new InvalidSamlRequestException("failed to validate a signature");
            }
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSamlRequestException("failed to decode a base64 signature string", e);
        }
        catch (SecurityException e) {
            throw new InvalidSamlRequestException("failed to validate a signature", e);
        }
    }

    @VisibleForTesting
    static String generateSignature(Credential signingCredential, String algorithmURI, String input) {
        try {
            byte[] signature = XMLSigningUtil.signWithURI((Credential)signingCredential, (String)algorithmURI, (byte[])input.getBytes(StandardCharsets.UTF_8));
            return Base64.getEncoder().encodeToString(signature);
        }
        catch (SecurityException e) {
            throw new SamlException("failed to generate a signature", e);
        }
    }

    static String toDeflatedBase64(SAMLObject message) {
        String messageStr;
        Objects.requireNonNull(message, "message");
        try {
            messageStr = SerializeSupport.nodeToString((Node)XMLObjectSupport.marshall((XMLObject)message));
        }
        catch (MarshallingException e) {
            throw new SamlException("failed to serialize a SAML message", e);
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (DeflaterOutputStream deflaterStream = new DeflaterOutputStream(Base64.getEncoder().wrap(bytesOut), new Deflater(8, true));){
            deflaterStream.write(messageStr.getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException e) {
            throw new SamlException("failed to deflate a SAML message", e);
        }
        return bytesOut.toString();
    }

    static XMLObject fromDeflatedBase64(String base64Encoded) {
        byte[] base64decoded;
        Objects.requireNonNull(base64Encoded, "base64Encoded");
        try {
            base64decoded = Base64.getMimeDecoder().decode(base64Encoded);
        }
        catch (IllegalArgumentException e) {
            throw new InvalidSamlRequestException("failed to decode a deflated base64 string", e);
        }
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        try (InflaterOutputStream inflaterOutputStream = new InflaterOutputStream(bytesOut, new Inflater(true));){
            inflaterOutputStream.write(base64decoded);
        }
        catch (IOException e) {
            throw new InvalidSamlRequestException("failed to inflate a SAML message", e);
        }
        return SamlMessageUtil.deserialize(bytesOut.toByteArray());
    }

    static <T extends SAMLObject> MessageContext<T> toSamlObject(AggregatedHttpRequest req, String name, Map<String, SamlIdentityProviderConfig> idpConfigs, @Nullable SamlIdentityProviderConfig defaultIdpConfig) {
        SamlIdentityProviderConfig config;
        Issuer issuer;
        Objects.requireNonNull(req, "req");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(idpConfigs, "idpConfigs");
        SamlService.SamlParameters parameters = new SamlService.SamlParameters(req);
        SAMLObject message = (SAMLObject)HttpRedirectBindingUtil.fromDeflatedBase64(parameters.getFirstValue(name));
        MessageContext messageContext = new MessageContext();
        messageContext.setMessage((Object)message);
        if (message instanceof RequestAbstractType) {
            issuer = ((RequestAbstractType)message).getIssuer();
        } else if (message instanceof StatusResponseType) {
            issuer = ((StatusResponseType)message).getIssuer();
        } else {
            throw new InvalidSamlRequestException("invalid message type: " + message.getClass().getSimpleName());
        }
        if (issuer != null) {
            String idpEntityId = issuer.getValue();
            config = idpConfigs.get(idpEntityId);
            if (config == null) {
                throw new InvalidSamlRequestException("a message from unknown identity provider: " + idpEntityId);
            }
        } else {
            if (defaultIdpConfig == null) {
                throw new InvalidSamlRequestException("failed to get an Issuer element");
            }
            config = defaultIdpConfig;
        }
        HttpRedirectBindingUtil.validateSignature(config.signingCredential(), parameters, name);
        String relayState = parameters.getFirstValueOrNull("RelayState");
        if (relayState != null) {
            SAMLBindingContext context = (SAMLBindingContext)messageContext.getSubcontext(SAMLBindingContext.class, true);
            assert (context != null);
            context.setRelayState(relayState);
        }
        return messageContext;
    }

    private HttpRedirectBindingUtil() {
    }
}

