/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.saml.SamlAssertionConsumerConfig;
import com.linecorp.armeria.server.saml.SamlEndpoint;
import com.linecorp.armeria.server.saml.SamlServiceProviderBuilder;
import java.util.Objects;

public final class SamlAssertionConsumerConfigBuilder {
    private final SamlServiceProviderBuilder parent;
    @Nullable
    private SamlEndpoint endpoint;
    private boolean isDefault;

    SamlAssertionConsumerConfigBuilder(SamlServiceProviderBuilder parent) {
        this.parent = parent;
    }

    SamlAssertionConsumerConfigBuilder(SamlServiceProviderBuilder parent, SamlEndpoint endpoint) {
        this.parent = parent;
        this.endpoint = endpoint;
    }

    @Deprecated
    public SamlAssertionConsumerConfigBuilder endpoint(SamlEndpoint endpoint) {
        this.endpoint = Objects.requireNonNull(endpoint, "endpoint");
        return this;
    }

    public SamlAssertionConsumerConfigBuilder asDefault() {
        this.isDefault = true;
        return this;
    }

    public SamlServiceProviderBuilder and() {
        return this.parent;
    }

    SamlAssertionConsumerConfig build() {
        Preconditions.checkState((this.endpoint != null ? 1 : 0) != 0, (Object)"The endpoint must not be null.");
        return new SamlAssertionConsumerConfig(this.endpoint, this.isDefault);
    }
}

