/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

final class SamlPortConfig {
    private final SessionProtocol scheme;
    private final int port;

    SamlPortConfig(SessionProtocol scheme, int port) {
        this.scheme = Objects.requireNonNull(scheme, "scheme");
        this.port = SamlPortConfig.validatePort(port);
    }

    SessionProtocol scheme() {
        return this.scheme;
    }

    int port() {
        return this.port;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scheme", (Object)this.scheme).add("port", this.port).toString();
    }

    static boolean isValidPort(int port) {
        return port > 0 && port <= 65535;
    }

    static int validatePort(int port) {
        Preconditions.checkArgument((boolean)SamlPortConfig.isValidPort(port), (String)"port: %s (expected: 1-65535)", (int)port);
        return port;
    }
}

