/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server.saml;

import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.server.ServerPort;
import com.linecorp.armeria.server.saml.SamlPortConfig;
import com.linecorp.armeria.server.saml.SamlPortConfigAutoFiller;
import java.util.Objects;

final class SamlPortConfigBuilder {
    @Nullable
    private SessionProtocol scheme;
    private int port;

    SamlPortConfigBuilder() {
    }

    @Nullable
    SessionProtocol scheme() {
        return this.scheme;
    }

    int port() {
        return this.port;
    }

    SamlPortConfigBuilder setSchemeIfAbsent(SessionProtocol scheme) {
        Objects.requireNonNull(scheme, "scheme");
        if (this.scheme == null) {
            if (scheme == SessionProtocol.HTTPS || scheme == SessionProtocol.HTTP) {
                this.scheme = scheme;
            } else {
                throw new IllegalArgumentException("unexpected session protocol: " + scheme);
            }
        }
        return this;
    }

    SamlPortConfigBuilder setPortIfAbsent(int port) {
        if (this.port == 0) {
            this.port = SamlPortConfig.validatePort(port);
        }
        return this;
    }

    SamlPortConfigBuilder setSchemeAndPortIfAbsent(ServerPort serverPort) {
        Objects.requireNonNull(serverPort, "serverPort");
        if (serverPort.hasHttps()) {
            this.setSchemeIfAbsent(SessionProtocol.HTTPS);
        } else if (serverPort.hasHttp()) {
            this.setSchemeIfAbsent(SessionProtocol.HTTP);
        } else {
            throw new IllegalArgumentException("unexpected session protocol: " + serverPort.protocols());
        }
        int port = serverPort.localAddress().getPort();
        if (SamlPortConfig.isValidPort(port)) {
            this.setPortIfAbsent(port);
        }
        return this;
    }

    SamlPortConfigAutoFiller toAutoFiller() {
        return new SamlPortConfigAutoFiller(SamlPortConfigBuilder.copyOf(this));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("scheme", (Object)this.scheme).add("port", this.port).toString();
    }

    private static SamlPortConfigBuilder copyOf(SamlPortConfigBuilder that) {
        SamlPortConfigBuilder builder = new SamlPortConfigBuilder();
        if (that.scheme != null) {
            builder.scheme = that.scheme;
        }
        if (SamlPortConfig.isValidPort(that.port)) {
            builder.port = that.port;
        }
        return builder;
    }
}

